using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

using System.Reflection;

namespace AssemblyExplorer
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		Assembly a=null;

		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.Container components = null;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Splitter splitter1;
		private System.Windows.Forms.Panel panel2;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.ListBox listBox1;
		private System.Windows.Forms.TreeView treeView1;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			/*
			//TEST
			a=Assembly.LoadFrom("d:\\JacekMatulewski.Util.dll");
			//a=Assembly.LoadFrom("d:\\JacekMatulewski.Reversi.dll");
			statusBar1.Text=a.ToString();
			listBox1.Items.AddRange(a.GetTypes());
			*/
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.panel1 = new System.Windows.Forms.Panel();
			this.listBox1 = new System.Windows.Forms.ListBox();
			this.splitter1 = new System.Windows.Forms.Splitter();
			this.panel2 = new System.Windows.Forms.Panel();
			this.treeView1 = new System.Windows.Forms.TreeView();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.panel1.SuspendLayout();
			this.panel2.SuspendLayout();
			this.SuspendLayout();
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem1,
						this.menuItem5});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem2,
						this.menuItem7,
						this.menuItem8,
						this.menuItem3,
						this.menuItem4});
			this.menuItem1.Text = "File";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
			this.menuItem2.Text = "Open an assembly";
			this.menuItem2.Click += new System.EventHandler(this.menuItem2_Click);
			// 
			// menuItem7
			// 
			this.menuItem7.Enabled = false;
			this.menuItem7.Index = 1;
			this.menuItem7.Shortcut = System.Windows.Forms.Shortcut.CtrlI;
			this.menuItem7.Text = "Assembly info";
			this.menuItem7.Click += new System.EventHandler(this.menuItem7_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 3;
			this.menuItem3.Text = "-";
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 4;
			this.menuItem4.Shortcut = System.Windows.Forms.Shortcut.AltF4;
			this.menuItem4.Text = "Exit";
			this.menuItem4.Click += new System.EventHandler(this.menuItem4_Click);
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 1;
			this.menuItem5.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem6});
			this.menuItem5.Text = "Help";
			// 
			// menuItem6
			// 
			this.menuItem6.Index = 0;
			this.menuItem6.Text = "About...";
			this.menuItem6.Click += new System.EventHandler(this.menuItem6_Click);
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.Filter = "Wszystkie pliki (*.*)|*.*|Biblioteki DLL (*.dll)| *.dll|Pliki wyko" +  
				"nywalne (*.exe)|*.exe";
			this.openFileDialog1.Title = "Setect an assembly file (.dll or .exe)";
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 328);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Size = new System.Drawing.Size(608, 16);
			this.statusBar1.TabIndex = 0;
			// 
			// panel1
			// 
			this.panel1.Controls.Add(this.listBox1);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Left;
			this.panel1.Location = new System.Drawing.Point(0, 0);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(168, 328);
			this.panel1.TabIndex = 1;
			// 
			// listBox1
			// 
			this.listBox1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.listBox1.ItemHeight = 16;
			this.listBox1.Location = new System.Drawing.Point(0, 0);
			this.listBox1.Name = "listBox1";
			this.listBox1.Size = new System.Drawing.Size(168, 324);
			this.listBox1.TabIndex = 0;
			this.listBox1.SelectedIndexChanged += new System.EventHandler(this.listBox1_SelectedIndexChanged);
			// 
			// splitter1
			// 
			this.splitter1.Location = new System.Drawing.Point(168, 0);
			this.splitter1.Name = "splitter1";
			this.splitter1.Size = new System.Drawing.Size(2, 328);
			this.splitter1.TabIndex = 2;
			this.splitter1.TabStop = false;
			// 
			// panel2
			// 
			this.panel2.Controls.Add(this.treeView1);
			this.panel2.Dock = System.Windows.Forms.DockStyle.Fill;
			this.panel2.Location = new System.Drawing.Point(170, 0);
			this.panel2.Name = "panel2";
			this.panel2.Size = new System.Drawing.Size(438, 328);
			this.panel2.TabIndex = 3;
			// 
			// treeView1
			// 
			this.treeView1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.treeView1.ImageIndex = -1;
			this.treeView1.Location = new System.Drawing.Point(0, 0);
			this.treeView1.Name = "treeView1";
			this.treeView1.SelectedImageIndex = -1;
			this.treeView1.Size = new System.Drawing.Size(438, 328);
			this.treeView1.TabIndex = 0;
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 2;
			this.menuItem8.Text = ".NET Info";
			this.menuItem8.Click += new System.EventHandler(this.menuItem8_Click);
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(6, 15);
			this.ClientSize = new System.Drawing.Size(608, 344);
			this.Controls.Add(this.panel2);
			this.Controls.Add(this.splitter1);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.statusBar1);
			this.Menu = this.mainMenu1;
			this.Name = "WinForm";
			this.Text = ".NET Assembly Explorer";
			this.panel1.ResumeLayout(false);
			this.panel2.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm());
		}

		private void menuItem2_Click(object sender, System.EventArgs e)
		{
			if (openFileDialog1.ShowDialog()==DialogResult.OK)
				{
				try
					{
					a=Assembly.LoadFrom(openFileDialog1.FileName);
					statusBar1.Text=a.ToString();
					this.Text=".NET Assembly Explorer - "+a.Location;
					listBox1.Items.Clear();
					listBox1.Items.AddRange(a.GetTypes());
					menuItem7.Enabled=true;
					}
				catch(Exception exc)
					{
					MessageBox.Show("Error: "+exc.Message);
					}
				}
		}

		private void menuItem4_Click(object sender, System.EventArgs e)
		{
			Close();
		}

		private void listBox1_SelectedIndexChanged(object sender, System.EventArgs e)
		{
			Type type=a.GetType(listBox1.SelectedItem.ToString());

			treeView1.BeginUpdate();
			treeView1.Nodes.Clear();

			treeView1.Nodes.Add(new TreeNode("Info"));
			treeView1.Nodes[0].Nodes.Add(new TreeNode("Name: "+type.FullName));
			treeView1.Nodes[0].Nodes.Add(new TreeNode("Assembly: "+type.Assembly));
			treeView1.Nodes[0].Nodes.Add(new TreeNode("Attributes: "+type.Attributes));
			treeView1.Nodes[0].Nodes.Add(new TreeNode("Scope: "+(type.IsPublic?"public":"not public")));
			treeView1.Nodes[0].Nodes.Add(new TreeNode("Class: "+type.IsClass));

			treeView1.Nodes.Add(new TreeNode("Fields"));
			FieldInfo[] fields=type.GetFields();
			foreach(FieldInfo field in fields) treeView1.Nodes[1].Nodes.Add((field.IsStatic?"static":"")+"  "+field.FieldType+"  "+field.Name);

			treeView1.Nodes.Add(new TreeNode("Constructors"));
			ConstructorInfo[] constructors=type.GetConstructors();
			foreach(ConstructorInfo constructor in constructors)
				{
				string parametersStr="";
				ParameterInfo[] parameters=constructor.GetParameters();
				foreach(ParameterInfo parameter in parameters) parametersStr+=parameter.ParameterType+" "+parameter.Name+",";
				if (parametersStr.Length>0) parametersStr=parametersStr.Substring(0,parametersStr.Length-1);
				treeView1.Nodes[2].Nodes.Add(type.Name+"("+parametersStr+")");
				}

			treeView1.Nodes.Add(new TreeNode("Methods"));
			MethodInfo[] methods=type.GetMethods();
			foreach(MethodInfo method in methods) treeView1.Nodes[3].Nodes.Add((method.IsStatic?"  static":"")+"  "+method.GetBaseDefinition());

			treeView1.Nodes.Add(new TreeNode("Properties"));
			PropertyInfo[] properties=type.GetProperties();
			foreach(PropertyInfo property in properties) treeView1.Nodes[4].Nodes.Add(""+property.PropertyType+"  "+property.Name+",   {"+(property.CanRead?"get; ":"")+(property.CanWrite?"set;":"")+"}");

			treeView1.Nodes.Add(new TreeNode("Events"));
			EventInfo[] events=type.GetEvents();
			foreach(EventInfo evnt in events) treeView1.Nodes[5].Nodes.Add(""+evnt.EventHandlerType+"  "+evnt.Name);

			treeView1.Nodes.Add(new TreeNode("Interfaces"));
			Type[] interaces=type.GetInterfaces();
			foreach(Type interf in interaces) treeView1.Nodes[6].Nodes.Add(""+interf.Name);

			treeView1.Nodes.Add(new TreeNode("Nested Types"));
			Type[] nestedTypes=type.GetNestedTypes();
			foreach(Type nestedType in nestedTypes) treeView1.Nodes[7].Nodes.Add(""+nestedType.Name);


			treeView1.EndUpdate();
		}

		private void menuItem6_Click(object sender, System.EventArgs e)
		{
			MessageBox.Show(".NET Assembly Explorer (version "+Application.ProductVersion+")  \n(c) Jacek Matulewski 2004\n\nNewest version can be downloaded from\nhttp://www.phys.uni.torun.pl/~jacek/download/  ",".NET Assembly Explorer");
		}

		private void menuItem7_Click(object sender, System.EventArgs e)
		{
			string info="";
			info+="Name:   "+a.FullName+"\n";
			info+="File:   "+a.Location+"\n";
			info+="Entry point:   "+a.EntryPoint+"\n";
			info+="Version:   "+a.ImageRuntimeVersion+"\n";

			/*
			string[] manfestResourceNames=a.GetManifestResourceNames();
			info+="Zasoby:   ";
			foreach(string s in manfestResourceNames) info+=s;
			*/

			/*
			ManifestResourceInfo mri=a.GetManifestResourceInfo((a.GetManifestResourceNames())[0]);
			info+="Manifest:   "+mri.ResourceLocation;
			*/

			MessageBox.Show(info,"Assembly info");
		}

		private void menuItem8_Click(object sender, System.EventArgs e)
		{
			string systeminfo="";
			systeminfo+="Operating system version: "+Environment.OSVersion;
			systeminfo+="\n.NET Framework version: "+Environment.Version;

			systeminfo+="\nComputer name: "+Environment.MachineName;
			systeminfo+="\nWindows directory: "+Environment.GetEnvironmentVariable("windir");
			systeminfo+="\nSystem directory: "+Environment.SystemDirectory;

			int ms_sekunda=1000;
			int ms_minuta=60*ms_sekunda;
			int ms_godzina=60*ms_minuta;
			int ms_doba=24*ms_godzina;
			int ile_ms=Environment.TickCount;
			int ile_dni=ile_ms/ms_doba;
			int reszta=ile_ms%ms_doba;
			int ile_godzin=reszta/ms_godzina;
			reszta%=ms_godzina;
			int ile_minut=reszta/ms_minuta;
			reszta%=ms_minuta;
			int ile_sekund=reszta/ms_sekunda;
			systeminfo+="\nDuration of current Windows session: "+ile_dni+" dni, "+ile_godzin+" h, "+ile_minut+" min, "+ile_sekund+" s";

			string[] dyski=Environment.GetLogicalDrives();
			systeminfo+="\nDrives: ";
			foreach(string dysk in dyski) systeminfo+=dysk+" ";

			MessageBox.Show(systeminfo,".NET info");
		}

	}
}
