using System;
using System.Drawing;
using System.Collections;
using System.ComponentModel;
using System.Windows.Forms;
using System.Data;

//Dodana dla Registry
using Microsoft.Win32; //platform dependent

namespace Pioro
{
	/// <summary>
	/// Summary description for WinForm.
	/// </summary>
	public class WinForm : System.Windows.Forms.Form
	{
		/// <summary>
		/// Required designer variable.
		/// </summary>
		private System.ComponentModel.IContainer components;
		private System.Windows.Forms.StatusBar statusBar1;
		private System.Windows.Forms.Panel panel1;
		private System.Windows.Forms.Button button1;
		private System.Windows.Forms.Button button2;
		private System.Windows.Forms.Button button3;
		private System.Windows.Forms.OpenFileDialog openFileDialog1;
		private System.Windows.Forms.SaveFileDialog saveFileDialog1;
		private System.Windows.Forms.MainMenu mainMenu1;
		private System.Windows.Forms.MenuItem menuItem1;
		private System.Windows.Forms.MenuItem menuItem2;
		private System.Windows.Forms.MenuItem menuItem3;
		private System.Windows.Forms.MenuItem menuItem4;
		private System.Windows.Forms.MenuItem menuItem5;
		private System.Windows.Forms.MenuItem menuItem13;
		private System.Windows.Forms.MenuItem menuItem14;
		private System.Windows.Forms.MenuItem menuItem15;
		private System.Windows.Forms.MenuItem menuItem16;
		private System.Windows.Forms.RichTextBox richTextBox1;
		private System.Windows.Forms.ToolBar toolBar1;
		private System.Windows.Forms.ToolBarButton toolBarButton1;
		private System.Windows.Forms.ToolBarButton toolBarButton2;
		private System.Windows.Forms.ToolBarButton toolBarButton3;
		private System.Windows.Forms.ToolBarButton toolBarButton4;
		private System.Windows.Forms.ToolBarButton toolBarButton5;
		private System.Windows.Forms.MenuItem menuItem6;
		private System.Windows.Forms.MenuItem menuItem7;
		private System.Windows.Forms.MenuItem menuItem8;
		private System.Windows.Forms.MenuItem menuItem9;
		private System.Windows.Forms.MenuItem menuItem10;
		private System.Windows.Forms.MenuItem menuItem11;
		private System.Windows.Forms.MenuItem menuItem12;
		private System.Windows.Forms.MenuItem menuItem17;
		private System.Windows.Forms.MenuItem menuItem18;
		private System.Windows.Forms.MenuItem menuItem19;
		private System.Windows.Forms.MenuItem menuItem20;
		private System.Windows.Forms.MenuItem menuItem21;
		private System.Windows.Forms.MenuItem menuItem22;
		private System.Windows.Forms.MenuItem menuItem23;
		private System.Windows.Forms.MenuItem menuItem24;
		private System.Windows.Forms.MenuItem menuItem25;
		private System.Windows.Forms.MenuItem menuItem26;
		private System.Windows.Forms.MenuItem menuItem27;
		private System.Windows.Forms.FontDialog fontDialog1;
		private System.Windows.Forms.ColorDialog colorDialog1;
		private System.Windows.Forms.ImageList imageList1;

		public WinForm()
		{
			//
			// Required for Windows Form Designer support
			//
			InitializeComponent();

			//
			// TODO: Add any constructor code after InitializeComponent call
			//
		}

		/// <summary>
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose (bool disposing)
		{
			if (disposing)
			{
				if (components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose(disposing);
		}

		#region Windows Form Designer generated code
		/// <summary>
		/// Required method for Designer support - do not modify
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(WinForm));
			this.statusBar1 = new System.Windows.Forms.StatusBar();
			this.panel1 = new System.Windows.Forms.Panel();
			this.button3 = new System.Windows.Forms.Button();
			this.button2 = new System.Windows.Forms.Button();
			this.button1 = new System.Windows.Forms.Button();
			this.openFileDialog1 = new System.Windows.Forms.OpenFileDialog();
			this.saveFileDialog1 = new System.Windows.Forms.SaveFileDialog();
			this.mainMenu1 = new System.Windows.Forms.MainMenu();
			this.menuItem1 = new System.Windows.Forms.MenuItem();
			this.menuItem2 = new System.Windows.Forms.MenuItem();
			this.menuItem3 = new System.Windows.Forms.MenuItem();
			this.menuItem4 = new System.Windows.Forms.MenuItem();
			this.menuItem5 = new System.Windows.Forms.MenuItem();
			this.menuItem7 = new System.Windows.Forms.MenuItem();
			this.menuItem8 = new System.Windows.Forms.MenuItem();
			this.menuItem9 = new System.Windows.Forms.MenuItem();
			this.menuItem10 = new System.Windows.Forms.MenuItem();
			this.menuItem11 = new System.Windows.Forms.MenuItem();
			this.menuItem12 = new System.Windows.Forms.MenuItem();
			this.menuItem17 = new System.Windows.Forms.MenuItem();
			this.menuItem20 = new System.Windows.Forms.MenuItem();
			this.menuItem18 = new System.Windows.Forms.MenuItem();
			this.menuItem19 = new System.Windows.Forms.MenuItem();
			this.menuItem21 = new System.Windows.Forms.MenuItem();
			this.menuItem22 = new System.Windows.Forms.MenuItem();
			this.menuItem23 = new System.Windows.Forms.MenuItem();
			this.menuItem24 = new System.Windows.Forms.MenuItem();
			this.menuItem25 = new System.Windows.Forms.MenuItem();
			this.menuItem26 = new System.Windows.Forms.MenuItem();
			this.menuItem27 = new System.Windows.Forms.MenuItem();
			this.menuItem13 = new System.Windows.Forms.MenuItem();
			this.menuItem14 = new System.Windows.Forms.MenuItem();
			this.menuItem6 = new System.Windows.Forms.MenuItem();
			this.menuItem15 = new System.Windows.Forms.MenuItem();
			this.menuItem16 = new System.Windows.Forms.MenuItem();
			this.richTextBox1 = new System.Windows.Forms.RichTextBox();
			this.toolBar1 = new System.Windows.Forms.ToolBar();
			this.toolBarButton1 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton2 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton3 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton4 = new System.Windows.Forms.ToolBarButton();
			this.toolBarButton5 = new System.Windows.Forms.ToolBarButton();
			this.fontDialog1 = new System.Windows.Forms.FontDialog();
			this.colorDialog1 = new System.Windows.Forms.ColorDialog();
			this.imageList1 = new System.Windows.Forms.ImageList(this.components);
			this.panel1.SuspendLayout();
			this.SuspendLayout();
			// 
			// statusBar1
			// 
			this.statusBar1.Location = new System.Drawing.Point(0, 351);
			this.statusBar1.Name = "statusBar1";
			this.statusBar1.Size = new System.Drawing.Size(512, 19);
			this.statusBar1.TabIndex = 0;
			this.statusBar1.Text = "< Brak dokumentu >";
			// 
			// panel1
			// 
			this.panel1.Controls.Add(this.button3);
			this.panel1.Controls.Add(this.button2);
			this.panel1.Controls.Add(this.button1);
			this.panel1.Dock = System.Windows.Forms.DockStyle.Bottom;
			this.panel1.Location = new System.Drawing.Point(0, 323);
			this.panel1.Name = "panel1";
			this.panel1.Size = new System.Drawing.Size(512, 28);
			this.panel1.TabIndex = 4;
			// 
			// button3
			// 
			this.button3.Dock = System.Windows.Forms.DockStyle.Fill;
			this.button3.Location = new System.Drawing.Point(62, 0);
			this.button3.Name = "button3";
			this.button3.Size = new System.Drawing.Size(390, 28);
			this.button3.TabIndex = 1;
			this.button3.Text = "Zapisz jako...";
			this.button3.Click += new System.EventHandler(this.button3_Click);
			// 
			// button2
			// 
			this.button2.Dock = System.Windows.Forms.DockStyle.Right;
			this.button2.Font = new System.Drawing.Font("Microsoft Sans Serif", 7.8F, System.Drawing.FontStyle.Bold, System.Drawing.GraphicsUnit.Point, ((byte)(238)));
			this.button2.Location = new System.Drawing.Point(452, 0);
			this.button2.Name = "button2";
			this.button2.Size = new System.Drawing.Size(60, 28);
			this.button2.TabIndex = 2;
			this.button2.Text = "Zamknij";
			this.button2.Click += new System.EventHandler(this.button2_Click);
			// 
			// button1
			// 
			this.button1.Dock = System.Windows.Forms.DockStyle.Left;
			this.button1.Location = new System.Drawing.Point(0, 0);
			this.button1.Name = "button1";
			this.button1.Size = new System.Drawing.Size(62, 28);
			this.button1.TabIndex = 0;
			this.button1.Text = "Otwrz...";
			this.button1.Click += new System.EventHandler(this.button1_Click);
			// 
			// openFileDialog1
			// 
			this.openFileDialog1.Filter = "Wszystkie pliki (*.*)|*.*|Dokument sformatowany (*.rtf)|*.rtf|Doku" +  
				"ment tekstowy (*.txt)|*.txt";
			this.openFileDialog1.InitialDirectory = ".";
			this.openFileDialog1.Title = "Wska dokument";
			// 
			// saveFileDialog1
			// 
			this.saveFileDialog1.Filter = "Dokument sformatowany (*.rtf)|*.rtf|Dokument tekstowy (*.txt)|*.tx" +  
				"t";
			this.saveFileDialog1.InitialDirectory = ".";
			this.saveFileDialog1.Title = "Zapisz dokument do pliku";
			// 
			// mainMenu1
			// 
			this.mainMenu1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem1,
						this.menuItem7,
						this.menuItem21,
						this.menuItem13});
			// 
			// menuItem1
			// 
			this.menuItem1.Index = 0;
			this.menuItem1.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem2,
						this.menuItem3,
						this.menuItem4,
						this.menuItem5});
			this.menuItem1.Text = "Plik";
			// 
			// menuItem2
			// 
			this.menuItem2.Index = 0;
			this.menuItem2.Shortcut = System.Windows.Forms.Shortcut.CtrlO;
			this.menuItem2.Text = "Otwrz...";
			this.menuItem2.Click += new System.EventHandler(this.button1_Click);
			// 
			// menuItem3
			// 
			this.menuItem3.Index = 1;
			this.menuItem3.Shortcut = System.Windows.Forms.Shortcut.CtrlS;
			this.menuItem3.Text = "Zapisz jako...";
			this.menuItem3.Click += new System.EventHandler(this.button3_Click);
			// 
			// menuItem4
			// 
			this.menuItem4.Index = 2;
			this.menuItem4.Text = "-";
			// 
			// menuItem5
			// 
			this.menuItem5.Index = 3;
			this.menuItem5.Shortcut = System.Windows.Forms.Shortcut.AltF4;
			this.menuItem5.Text = "Zamknij";
			this.menuItem5.Click += new System.EventHandler(this.button2_Click);
			// 
			// menuItem7
			// 
			this.menuItem7.Index = 1;
			this.menuItem7.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem8,
						this.menuItem9,
						this.menuItem10,
						this.menuItem11,
						this.menuItem12,
						this.menuItem17,
						this.menuItem20,
						this.menuItem18,
						this.menuItem19});
			this.menuItem7.Text = "Edycja";
			this.menuItem7.Popup += new System.EventHandler(this.menuItem7_Popup);
			// 
			// menuItem8
			// 
			this.menuItem8.Index = 0;
			this.menuItem8.Shortcut = System.Windows.Forms.Shortcut.CtrlZ;
			this.menuItem8.Text = "Cofnij";
			this.menuItem8.Click += new System.EventHandler(this.menuItem8_Click);
			// 
			// menuItem9
			// 
			this.menuItem9.Index = 1;
			this.menuItem9.Shortcut = System.Windows.Forms.Shortcut.CtrlY;
			this.menuItem9.Text = "Redo";
			this.menuItem9.Click += new System.EventHandler(this.menuItem9_Click);
			// 
			// menuItem10
			// 
			this.menuItem10.Index = 2;
			this.menuItem10.Text = "-";
			// 
			// menuItem11
			// 
			this.menuItem11.Index = 3;
			this.menuItem11.Shortcut = System.Windows.Forms.Shortcut.CtrlX;
			this.menuItem11.Text = "Wytnij";
			this.menuItem11.Click += new System.EventHandler(this.menuItem11_Click);
			// 
			// menuItem12
			// 
			this.menuItem12.Index = 4;
			this.menuItem12.Shortcut = System.Windows.Forms.Shortcut.CtrlC;
			this.menuItem12.Text = "Kopiuj";
			this.menuItem12.Click += new System.EventHandler(this.menuItem12_Click);
			// 
			// menuItem17
			// 
			this.menuItem17.Index = 5;
			this.menuItem17.Shortcut = System.Windows.Forms.Shortcut.CtrlV;
			this.menuItem17.Text = "Wklej";
			this.menuItem17.Click += new System.EventHandler(this.menuItem17_Click);
			// 
			// menuItem20
			// 
			this.menuItem20.Index = 6;
			this.menuItem20.Shortcut = System.Windows.Forms.Shortcut.Del;
			this.menuItem20.Text = "Usu";
			this.menuItem20.Click += new System.EventHandler(this.menuItem20_Click);
			// 
			// menuItem18
			// 
			this.menuItem18.Index = 7;
			this.menuItem18.Text = "-";
			// 
			// menuItem19
			// 
			this.menuItem19.Index = 8;
			this.menuItem19.Shortcut = System.Windows.Forms.Shortcut.CtrlA;
			this.menuItem19.Text = "Zaznacz wszystko";
			this.menuItem19.Click += new System.EventHandler(this.menuItem19_Click);
			// 
			// menuItem21
			// 
			this.menuItem21.Index = 2;
			this.menuItem21.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem22,
						this.menuItem23,
						this.menuItem24,
						this.menuItem25,
						this.menuItem26,
						this.menuItem27});
			this.menuItem21.Text = "Format";
			// 
			// menuItem22
			// 
			this.menuItem22.Index = 0;
			this.menuItem22.Text = "Czcionka...";
			this.menuItem22.Click += new System.EventHandler(this.menuItem22_Click);
			// 
			// menuItem23
			// 
			this.menuItem23.Index = 1;
			this.menuItem23.Text = "Kolor ta...";
			this.menuItem23.Click += new System.EventHandler(this.menuItem23_Click);
			// 
			// menuItem24
			// 
			this.menuItem24.Index = 2;
			this.menuItem24.Text = "-";
			// 
			// menuItem25
			// 
			this.menuItem25.Index = 3;
			this.menuItem25.Text = "Przybli";
			this.menuItem25.Click += new System.EventHandler(this.menuItem25_Click);
			// 
			// menuItem26
			// 
			this.menuItem26.Index = 4;
			this.menuItem26.Text = "Oddal";
			this.menuItem26.Click += new System.EventHandler(this.menuItem26_Click);
			// 
			// menuItem27
			// 
			this.menuItem27.Index = 5;
			this.menuItem27.Text = "Zblienie normalne";
			this.menuItem27.Click += new System.EventHandler(this.menuItem27_Click);
			// 
			// menuItem13
			// 
			this.menuItem13.Index = 3;
			this.menuItem13.MenuItems.AddRange(new System.Windows.Forms.MenuItem[] {
						this.menuItem14,
						this.menuItem6,
						this.menuItem15,
						this.menuItem16});
			this.menuItem13.Text = "Widok";
			// 
			// menuItem14
			// 
			this.menuItem14.Index = 0;
			this.menuItem14.Text = "Przyciski";
			this.menuItem14.Click += new System.EventHandler(this.menuItem14_Click);
			// 
			// menuItem6
			// 
			this.menuItem6.Checked = true;
			this.menuItem6.Index = 1;
			this.menuItem6.Text = "Pasek narzdzi";
			this.menuItem6.Click += new System.EventHandler(this.menuItem14_Click);
			// 
			// menuItem15
			// 
			this.menuItem15.Checked = true;
			this.menuItem15.Index = 2;
			this.menuItem15.Text = "Pasek stanu";
			this.menuItem15.Click += new System.EventHandler(this.menuItem14_Click);
			// 
			// menuItem16
			// 
			this.menuItem16.Index = 3;
			this.menuItem16.Text = "Ukryj menu";
			this.menuItem16.Click += new System.EventHandler(this.menuItem16_Click);
			// 
			// richTextBox1
			// 
			this.richTextBox1.Dock = System.Windows.Forms.DockStyle.Fill;
			this.richTextBox1.Location = new System.Drawing.Point(0, 28);
			this.richTextBox1.Name = "richTextBox1";
			this.richTextBox1.Size = new System.Drawing.Size(512, 295);
			this.richTextBox1.TabIndex = 5;
			this.richTextBox1.Text = "";
			// 
			// toolBar1
			// 
			this.toolBar1.Buttons.AddRange(new System.Windows.Forms.ToolBarButton[] {
						this.toolBarButton1,
						this.toolBarButton2,
						this.toolBarButton3,
						this.toolBarButton4,
						this.toolBarButton5});
			this.toolBar1.ButtonSize = new System.Drawing.Size(25, 18);
			this.toolBar1.DropDownArrows = true;
			this.toolBar1.ImageList = this.imageList1;
			this.toolBar1.Location = new System.Drawing.Point(0, 0);
			this.toolBar1.Name = "toolBar1";
			this.toolBar1.ShowToolTips = true;
			this.toolBar1.Size = new System.Drawing.Size(512, 28);
			this.toolBar1.TabIndex = 6;
			this.toolBar1.TextAlign = System.Windows.Forms.ToolBarTextAlign.Right;
			this.toolBar1.ButtonClick += new System.Windows.Forms.ToolBarButtonClickEventHandler(this.toolBar1_ButtonClick);
			// 
			// toolBarButton1
			// 
			this.toolBarButton1.ImageIndex = 0;
			this.toolBarButton1.ToolTipText = "Zmiana czcionki";
			// 
			// toolBarButton2
			// 
			this.toolBarButton2.Style = System.Windows.Forms.ToolBarButtonStyle.Separator;
			// 
			// toolBarButton3
			// 
			this.toolBarButton3.ImageIndex = 1;
			this.toolBarButton3.ToolTipText = "Wytuszczenie";
			// 
			// toolBarButton4
			// 
			this.toolBarButton4.ImageIndex = 2;
			this.toolBarButton4.ToolTipText = "Kursywa";
			// 
			// toolBarButton5
			// 
			this.toolBarButton5.ImageIndex = 3;
			this.toolBarButton5.ToolTipText = "Podkrelenie";
			// 
			// fontDialog1
			// 
			this.fontDialog1.ShowColor = true;
			// 
			// colorDialog1
			// 
			this.colorDialog1.AnyColor = true;
			// 
			// imageList1
			// 
			this.imageList1.ImageSize = new System.Drawing.Size(16, 16);
			this.imageList1.ImageStream = ((System.Windows.Forms.ImageListStreamer)(resources.GetObject("imageList1.ImageStream")));
			this.imageList1.TransparentColor = System.Drawing.Color.Transparent;
			// 
			// WinForm
			// 
			this.AutoScaleBaseSize = new System.Drawing.Size(5, 13);
			this.ClientSize = new System.Drawing.Size(512, 370);
			this.Controls.Add(this.richTextBox1);
			this.Controls.Add(this.panel1);
			this.Controls.Add(this.statusBar1);
			this.Controls.Add(this.toolBar1);
			this.Icon = ((System.Drawing.Icon)(resources.GetObject("$this.Icon")));
			this.KeyPreview = true;
			this.Menu = this.mainMenu1;
			this.MinimumSize = new System.Drawing.Size(250, 150);
			this.Name = "WinForm";
			this.RightToLeft = System.Windows.Forms.RightToLeft.No;
			this.Text = "Piro";
			this.Resize += new System.EventHandler(this.WinForm_Resize);
			this.Load += new System.EventHandler(this.WinForm_Load);
			this.panel1.ResumeLayout(false);
			this.ResumeLayout(false);
		}
		#endregion

		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main()
		{
			Application.Run(new WinForm());
		}

		private void WinForm_Resize(object sender, System.EventArgs e)
		{
			int szerokoscPrzycisku=panel1.Width/3;
			button1.Width=szerokoscPrzycisku;
			button2.Width=szerokoscPrzycisku;
			button3.Width=szerokoscPrzycisku;
			//if (Height<5*panel1.Height) Height=5*panel1.Height;
		}

		private void WinForm_Load(object sender, System.EventArgs e)
		{
			WinForm_Resize(null,null);
			menuItem14_Click(null,null);
		}

		private void button2_Click(object sender, System.EventArgs e)
		{
			//Close();
			Application.Exit();
		}

		private void button1_Click(object sender, System.EventArgs e)
		{
			string sciezkaDoMojeDokumenty=pobierzSciezkeDoMojeDokumenty();
			if (sciezkaDoMojeDokumenty!=null) openFileDialog1.InitialDirectory=sciezkaDoMojeDokumenty;

			if (openFileDialog1.ShowDialog()==DialogResult.OK)
				{
				string nazwaPliku=openFileDialog1.FileName;
				try
					{
					RichTextBoxStreamType formatPliku;
					if (nazwaPliku.EndsWith("rtf"))
						formatPliku=RichTextBoxStreamType.RichText;
						else
						formatPliku=RichTextBoxStreamType.PlainText;

					richTextBox1.LoadFile(nazwaPliku,formatPliku);
					statusBar1.Text=nazwaPliku;
					}
				catch(OutOfMemoryException exc)
					{
					MessageBox.Show("Bd wczytywania dokumentu "+nazwaPliku+exc.Message,
									"Pioro - Bd przy wczytywaniu dokumentu",
									MessageBoxButtons.OK,
									MessageBoxIcon.Exclamation);
					}
				}
		}

		private void button3_Click(object sender, System.EventArgs e)
		{
			//Proba odczytu sciezki do pliku z wczytanym dokumentem
			string nazwaPliku=openFileDialog1.FileName;
			if (nazwaPliku.Length>0)
				saveFileDialog1.FileName=nazwaPliku.Substring(0,nazwaPliku.IndexOf('.'));

			if (saveFileDialog1.ShowDialog()==DialogResult.OK)
				{
				nazwaPliku=saveFileDialog1.FileName;
				if (nazwaPliku==openFileDialog1.FileName)
					{
					MessageBox.Show("Nie mona zapisac dokumentu do pliku, z ktrego jest wczytany");
					return;
					}
				RichTextBoxStreamType formatPliku;
				//Plik RTF (*.rtf)|*.rtf|
				//Plik TXT (*.txt)|*.txt|
				switch(saveFileDialog1.FilterIndex)
					{
					case 1: formatPliku=RichTextBoxStreamType.RichText; break;
					case 2: formatPliku=RichTextBoxStreamType.PlainText; break;
					default:
						//formatPliku=null;
						MessageBox.Show("To nie moliwe!");
						return;
						//break;
					}
				richTextBox1.SaveFile(nazwaPliku,formatPliku);
				}
		}

		//metoda zwracajaca sciezke do katalogu Moje dokumenty
		//using Microsoft.Win32; //platform dependent
		private string pobierzSciezkeDoMojeDokumenty()
		{
			const string nazwaKlucza="Software\\Microsoft\\Windows\\CurrentVersion\\Explorer\\Shell Folders";
			const string nazwaWartosci="Personal";
			try
				{
				RegistryKey rejestr=Registry.CurrentUser.OpenSubKey(nazwaKlucza);
				if (rejestr==null) throw new Exception("brak klucza '"+nazwaKlucza+"'");
				string sciezkaDoMojeDokumenty=(string)rejestr.GetValue(nazwaWartosci);
				if (sciezkaDoMojeDokumenty==null) throw new Exception("brak wartosci '"+nazwaWartosci+"'");
				rejestr.Close();
				return sciezkaDoMojeDokumenty;
				}
			catch(Exception exc)
				{
				MessageBox.Show("Bd przy czytaniu rejestru: "+exc.Message+".");
				return null;
				}
		}

		private void menuItem14_Click(object sender, System.EventArgs e)
		{
			if (sender!=null)
				{
				MenuItem miSender=(MenuItem)sender;
				miSender.Checked=!miSender.Checked;
				}

			panel1.Visible=menuItem14.Checked;
			statusBar1.Visible=menuItem15.Checked;
			toolBar1.Visible=menuItem6.Checked;
		}

		private void menuItem16_Click(object sender, System.EventArgs e)
		{
			this.Menu=null;
			//this.Menu=mainMenu1;
		}
		
		private void menuItem8_Click(object sender, System.EventArgs e)
		{
			richTextBox1.Undo();
		}

		private void menuItem9_Click(object sender, System.EventArgs e)
		{
			richTextBox1.Redo();
		}

		private void menuItem11_Click(object sender, System.EventArgs e)
		{
			richTextBox1.Cut();
		}
		
		private void menuItem12_Click(object sender, System.EventArgs e)
		{
			richTextBox1.Copy();
		}
		
		private void menuItem17_Click(object sender, System.EventArgs e)
		{
			richTextBox1.Paste();
		}
		
		private void menuItem20_Click(object sender, System.EventArgs e)
		{
			richTextBox1.SelectedText="";
		}
		
		private void menuItem19_Click(object sender, System.EventArgs e)
		{
			richTextBox1.SelectAll();
		}
		
		private void menuItem7_Popup(object sender, System.EventArgs e)
		{
			menuItem8.Enabled=richTextBox1.CanUndo;
			menuItem9.Enabled=richTextBox1.CanRedo;
			//menuItem17.Enabled=(richTextBox1.CanPaste(DataFormats.GetFormat(DataFormats.Rtf)) || richTextBox1.CanPaste(DataFormats.GetFormat(DataFormats.Text)));
		}
		
		private void menuItem22_Click(object sender, System.EventArgs e)
		{
			/*
			fontDialog1.Font=richTextBox1.Font;
			if (fontDialog1.ShowDialog()==DialogResult.OK)
				richTextBox1.Font=fontDialog1.Font;
			*/

			fontDialog1.Font=richTextBox1.SelectionFont;
			fontDialog1.Color=richTextBox1.SelectionColor;
			if (fontDialog1.ShowDialog()==DialogResult.OK)
				{
				richTextBox1.SelectionFont=fontDialog1.Font;
				richTextBox1.SelectionColor=fontDialog1.Color;
				}
		}

		private void menuItem23_Click(object sender, System.EventArgs e)
		{
			colorDialog1.Color=richTextBox1.BackColor;
			if (colorDialog1.ShowDialog()==DialogResult.OK)
				richTextBox1.BackColor=colorDialog1.Color;
		}
		
		private void menuItem25_Click(object sender, System.EventArgs e)
		{
			richTextBox1.ZoomFactor*=1.5f;
		}

		private void menuItem26_Click(object sender, System.EventArgs e)
		{
			richTextBox1.ZoomFactor/=1.5f;
		}

		private void menuItem27_Click(object sender, System.EventArgs e)
		{
			richTextBox1.ZoomFactor=1.0f;
		}

		private void toolBar1_ButtonClick(object sender, System.Windows.Forms.ToolBarButtonClickEventArgs e)
		{
			if(e.Button==toolBarButton1)
				menuItem22_Click(sender,e);

			if(e.Button==toolBarButton3 || e.Button==toolBarButton4 || e.Button==toolBarButton5)
				{

				FontStyle stylCzcionki=richTextBox1.SelectionFont.Style;

				if(e.Button==toolBarButton3)
					if (!richTextBox1.SelectionFont.Bold)
						stylCzcionki|=FontStyle.Bold;
						else
						stylCzcionki-=FontStyle.Bold;
				if(e.Button==toolBarButton4)
					if (!richTextBox1.SelectionFont.Italic)
						stylCzcionki|=FontStyle.Italic;
						else
						stylCzcionki-=FontStyle.Italic;
				if(e.Button==toolBarButton5)
					if (!richTextBox1.SelectionFont.Underline)
						stylCzcionki|=FontStyle.Underline;
						else
						stylCzcionki-=FontStyle.Underline;

				Font czcionka=new Font(richTextBox1.SelectionFont,stylCzcionki);
				richTextBox1.SelectionFont=czcionka;
               	}
		}
	}
}
