using System;

namespace SystemInfo
{
	/// <summary>
	/// Summary description for Class.
	/// </summary>
	class Class
	{
		/// <summary>
		/// The main entry point for the application.
		/// </summary>
		[STAThread]
		static void Main(string[] args)
		{
			//Informacje o systemie
			string systeminfo="Informacje o systemie:";
			systeminfo+="\nWersja systemu: "+Environment.OSVersion;
			systeminfo+="\nWersja Microsoft .NET Framework: "+Environment.Version;

			systeminfo+="\nNazwa komputera: "+Environment.MachineName;
			systeminfo+="\nKatalog Windows: "+Environment.GetEnvironmentVariable("windir");
			systeminfo+="\nKatalog systemowy: "+Environment.SystemDirectory;
			systeminfo+="\nKatalog 'Program Files': "+Environment.GetFolderPath(Environment.SpecialFolder.ProgramFiles);

			int ms_sekunda=1000;
			int ms_minuta=60*ms_sekunda;
			int ms_godzina=60*ms_minuta;
			int ms_doba=24*ms_godzina;
			int ile_ms=Environment.TickCount;
			int ile_dni=ile_ms/ms_doba;
			int reszta=ile_ms%ms_doba;
			int ile_godzin=reszta/ms_godzina;
			reszta%=ms_godzina;
			int ile_minut=reszta/ms_minuta;
			reszta%=ms_minuta;
			int ile_sekund=reszta/ms_sekunda;
			systeminfo+="\nCzas trwania biecej sesji: "+ile_dni+" dni, "+ile_godzin+" h, "+ile_minut+" min, "+ile_sekund+" s ("+ile_ms+" ms)";

			string[] dyski=Environment.GetLogicalDrives();
			systeminfo+="\nDyski: ";
			foreach(string dysk in dyski) systeminfo+=dysk+" ";

			//Informacje o uzytkowniku
			string userinfo="Informacje o biecym uytkowniku";
			userinfo+="\nNazwa uytkownika: "+Environment.UserName;

			string zmienne="";
			System.Collections.IDictionary zmienneSrodowiskowe=Environment.GetEnvironmentVariables();
			foreach (System.Collections.DictionaryEntry zmienna in zmienneSrodowiskowe)
				zmienne+="\t"+zmienna.Key +" = "+zmienna.Value+"\n";
			userinfo+="\nZmienne rodowiskowe:\n"+zmienne;

			userinfo+="\nKatalogi specjalne uytkownika:";
			userinfo+="\n\tKatalog domowy uytkownika: "+Environment.GetEnvironmentVariable("USERPROFILE");
			userinfo+="\n\tkatalog 'Moje dokumenty' = "+Environment.GetFolderPath(Environment.SpecialFolder.Personal);
			userinfo+="\n\tkatalog 'Pulpit' = "+Environment.GetFolderPath(Environment.SpecialFolder.Desktop);
			userinfo+="\n\tkatalog 'Moj komputer' = "+Environment.GetFolderPath(Environment.SpecialFolder.MyComputer);
			userinfo+="\n\tkatalog 'Moje obrazy' = "+Environment.GetFolderPath(Environment.SpecialFolder.MyPictures);
			userinfo+="\n\tkatalog menu Start = "+Environment.GetFolderPath(Environment.SpecialFolder.StartMenu);
			userinfo+="\n\tkatalog 'Programy' = "+Environment.GetFolderPath(Environment.SpecialFolder.Programs);
			userinfo+="\n\tkatalog 'Autostart' = "+Environment.GetFolderPath(Environment.SpecialFolder.Startup);
			userinfo+="\n\tkatalog 'Wylij do' = "+Environment.GetFolderPath(Environment.SpecialFolder.SendTo);


			Console.WriteLine("SystemInfo\n----------\n");
			Console.WriteLine(systeminfo+"\n");
			Console.WriteLine(userinfo+"\n");
			//Console.ReadLine();
		}
	}
}
