#ifndef MOJEOKNOGL_H
#define MOJEOKNOGL_H

#include "OknoGL.h"

enum Aktor {trojkat=0,bialaKostka,kolorowaKostka,kostkaZTeksturami,sfera,latarnia};

class CMojeOknoGL : public COknoGL
{
	private:
		void RysujTrojkat(float x0,float y0,float z0) const;
		unsigned int TworzListyWyswietlania(float dx,float dy,float dz,bool koloruj) const;
	private: 
		Aktor aktor;
		void RysujAktorow();
	//timer animacji
	private:
		float przesuniecie;
		long poprzedniCzas;
	protected:
		LRESULT WndProc(HWND hWnd, UINT message, WPARAM wParam,LPARAM lParam);		
	//zrodla swiatla
	private:
		void ZrodlaSwiatla();
		void MlecznaZarowka(float jasnosc);
		void ZoltaIZielonaMleczneZarowki();
		void Reflektor(float jasnoscRozblysk=1.0f,float jasnoscRozproszone=0.3f);
	//teksturowanie
	private:
		unsigned int indeksTekstury[3];
		void PrzygotujTekstury();
	//shadery
	private:
		unsigned int program;
		bool CzyShaderyDostepne();
		unsigned int PrzygotujShadery();
		void ZmienStalaCzas(unsigned int program,float czas=0.0f);
		void WiazDwieTekstury(unsigned int program,const unsigned int* indeksTekstury);
		void CMojeOknoGL::ZwolnijDwieTekstury();

	public:
		CMojeOknoGL();
} okno;

COknoGL* p_okno=&okno;

#endif