/* COLORMAPS 1.0  (c) Jacek Matulewski 2002 */
/*C++ Builder TColor type is same as int here: rgb2int(), int2rgb())*/

typedef unsigned char cm_byte;
typedef short int cm_angle;

const char colormaps_version[255]="colormaps, ver. 1.00.09 (c) Jacek Matulewski 2002";

double colormaps_gamma=1;

struct rgb_triplet /*RGB_709*/
	{
	cm_byte r;
    cm_byte g;
    cm_byte b;
    };

const rgb_triplet rgb_white={255,255,255};
const rgb_triplet rgb_yellow={255,255,0};
const rgb_triplet rgb_cyan={0,255,255};
const rgb_triplet rgb_green={0,255,0};
const rgb_triplet rgb_magenta={255,0,255};
const rgb_triplet rgb_red={255,0,0};
const rgb_triplet rgb_blue={0,0,255};
const rgb_triplet rgb_black={0,0,0};


struct nlrgb_triplet /* nonlinear RGB_709*/
	{
	cm_byte r;
    cm_byte g;
    cm_byte b;
    };


struct cmy_triplet
	{
        cm_byte c;
        cm_byte m;
        cm_byte y;
        cm_byte k;
        };

struct hsb_triplet
	{
        cm_angle h; //[0:360]
        cm_byte s;  //[0:255]
        cm_byte b;  //[0:255]
        };

struct hsv_triplet
	{
        cm_angle h; //[0:360]
        cm_byte s;  //[0:100]
        cm_byte v;  //[0:100]
        };

struct cieXYZ_triplet
	{
    double X; //[0:1]
    double Y; //[0:1]
    double Z; //[0:1]
    };

struct ciexyz_triplet
	{
    double x; //[0:1]
    double y; //[0:1]
    double z; //[0:1]
    };

struct ciexyY_triplet
	{
    double x; //[0:1]
    double y; //[0:1]
    double Y; //[0:1]
    };

struct YPbPr_triplet
	{
    double Y;  //[0:1]
    double Pb; //[-0.5:0.5]
    double Pr; //[-0.5:0.5]
    };

struct cieLUV_triplet
	{
    double L; //[0:100] lightness
    double U;
    double V;
    };
