//---------------------------------------------------------------------------

#include <vcl.h>
#pragma hdrstop

#include <typeinfo>

#include "Unit1.h"
#include "Drukowanie.h"
#include "Unit2.h"
//---------------------------------------------------------------------------
#pragma package(smart_init)
#pragma resource "*.dfm"
TForm1 *Form1;
//---------------------------------------------------------------------------
__fastcall TForm1::TForm1(TComponent* Owner)
	: TForm(Owner)
{
}
//---------------------------------------------------------------------------
void KopiujJpegDoBitmap(TImage* Image)
{
	if (Image->Picture->Graphic->ClassNameIs("TJPEGImage"))
	{
		TJPEGImage* jpeg=new TJPEGImage();
		jpeg->Assign(Image->Picture->Graphic);
		Image->Picture->Bitmap->Assign(jpeg);
		delete jpeg;
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Image1DblClick(TObject *Sender)
{
	if (OpenDialog1->Execute())
	{
		Image1->Picture->LoadFromFile(OpenDialog1->FileName);
		KopiujJpegDoBitmap(Image1);
		Form1->Caption=OpenDialog1->FileName;
		StatusBar1->Panels->Items[0]->Text=ExtractFileName(OpenDialog1->FileName);
		StatusBar1->Panels->Items[1]->Text=IntToStr(Image1->Picture->Width)+" x " +IntToStr(Image1->Picture->Height);
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormKeyDown(TObject *Sender, WORD &Key,
	  TShiftState Shift)
{
	switch (Key)
	{
		case VK_ESCAPE: Close(); break;
		case 'O': Image1DblClick(Sender); break;
		case 'S': Zapiszjako1Click(Sender); break;
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::FormCreate(TObject *Sender)
{
	AnsiString NazwaPliku;
	if (_argc>1)
	{
		NazwaPliku=_argv[1];
		if (FileExists(NazwaPliku))
		{
			Image1->Picture->LoadFromFile(NazwaPliku);
			KopiujJpegDoBitmap(Image1);
			this->Caption=NazwaPliku;
			StatusBar1->Panels->Items[0]->Text=ExtractFileName(NazwaPliku);
			StatusBar1->Panels->Items[1]->Text=IntToStr(Image1->Picture->Width)+" x " +IntToStr(Image1->Picture->Height);
		}
		else
		ShowMessage("Plik "+NazwaPliku+" nie istnieje!");
	}
}
//---------------------------------------------------------------------------
void __fastcall TForm1::Zakocz1Click(TObject *Sender)
{
	Close();
}
//---------------------------------------------------------------------------


void __fastcall TForm1::Negatyw1Click(TObject *Sender)
{
	Screen->Cursor=crHourGlass;
	for(int y=0;y<Image1->Picture->Bitmap->Height;y++)
		for(int x=0;x<Image1->Picture->Bitmap->Width;x++)
		{
			TColor kolor=Image1->Picture->Bitmap->Canvas->Pixels[x][y];
			int r=GetRValue(kolor);
			int g=GetGValue(kolor);
			int b=GetBValue(kolor);
			kolor=(TColor)RGB(255-r,255-g,255-b);
			Image1->Picture->Bitmap->Canvas->Pixels[x][y]=kolor;
		}
	Screen->Cursor=crDefault;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Negatyw2Click(TObject *Sender)
{
	Screen->Cursor=crHourGlass;
	for(int y=0;y<Image1->Picture->Bitmap->Height;y++)
		for(int x=0;x<Image1->Picture->Bitmap->Width;x++)
		{
			TColor kolor=Image1->Picture->Bitmap->Canvas->Pixels[x][y];
			kolor=(TColor)(~kolor & 0x00FFFFFF);
			Image1->Picture->Bitmap->Canvas->Pixels[x][y]=kolor;
		}
	Screen->Cursor=crDefault;
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Negatyw3Click(TObject *Sender)
{
	int IloscBajtowWLinii=(int)Image1->Picture->Bitmap->ScanLine[0]-(int)Image1->Picture->Bitmap->ScanLine[1];
	for(int y=0;y<Image1->Picture->Bitmap->Height;y++)
	{
		byte* p=(byte*)Image1->Picture->Bitmap->ScanLine[y];
		for(int n=0;n<IloscBajtowWLinii;n++) p[n]=~p[n];
	}
	Refresh();
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Drukuj1Click(TObject *Sender)
{
	TMarginesy marginesy;
	marginesy.Lewy=500;
	marginesy.Prawy=500;
	marginesy.Gorny=500;
	marginesy.Dolny=500;
	Drukuj(Image1->Picture->Graphic,true,false,"Drukowanie obrazu z aplikacji "+Application->Title,marginesy);
}
//---------------------------------------------------------------------------

void __fastcall TForm1::O1Click(TObject *Sender)
{
	Form2->ShowModal();	
}
//---------------------------------------------------------------------------

void __fastcall TForm1::Zapiszjako1Click(TObject *Sender)
{
	if (SaveDialog1->Execute())
	{
		Image1->Picture->SaveToFile(SaveDialog1->FileName);
		Form1->Caption=SaveDialog1->FileName;
	}
}
//---------------------------------------------------------------------------

