package helion.r2;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class OperacjeLogiczne extends Applet {
  private boolean isStandalone = false;
  Choice choice2 = new Choice();
  Choice choice1 = new Choice();
  TextField textField1 = new TextField();
  Choice choice3 = new Choice();
  //Get a parameter value
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public OperacjeLogiczne() {
  }
  //Initialize the applet
  public void init()
  {
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }

    //ustalanie zawartosci rozwijalnych list
    choice1.add("prawda");
    choice1.add("fasz");
    choice3.add("prawda");
    choice3.add("fasz");
    choice2.add(" AND ");
    choice2.add(" OR ");
    choice2.add(" XOR ");
    choice2.add(" -> ");
    choice2.add(" <-> ");
    choice1_itemStateChanged(null);
  }
  //Component initialization
  private void jbInit() throws Exception {
    choice3.setFont(new java.awt.Font("Monospaced", 0, 16));
    choice3.setBounds(new Rectangle(213, 12, 85, 30));
    choice3.addItemListener(new OperacjeLogiczne_choice3_itemAdapter(this));
    textField1.setBounds(new Rectangle(313, 12, 85, 30));
    textField1.setEditable(false);
    textField1.setFont(new java.awt.Font("Dialog", 0, 16));
    textField1.setText("");
    choice1.setFont(new java.awt.Font("Monospaced", 0, 16));
    choice1.setBounds(new Rectangle(13, 12, 85, 30));
    choice1.addItemListener(new OperacjeLogiczne_choice1_itemAdapter(this));
    choice2.setFont(new java.awt.Font("Monospaced", 0, 16));
    choice2.setBounds(new Rectangle(113, 12, 85, 30));
    choice2.addItemListener(new OperacjeLogiczne_choice2_itemAdapter(this));
    this.setLayout(null);
    this.setBackground(SystemColor.window);
    this.add(choice1, null);
    this.add(choice2, null);
    this.add(choice3, null);
    this.add(textField1, null);
  }
  //Get Applet information
  public String getAppletInfo() {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo() {
    return null;
  }

  boolean implikacja(boolean p,boolean w)
  {
    return !(p && !w);
  }

  boolean rownowaznosc(boolean p,boolean q)
  {
    return (implikacja(p,q) && implikacja(q,p));
    //return (p==q);
  }

  void choice1_itemStateChanged(ItemEvent e)
  {
    boolean l=(choice1.getSelectedItem()=="prawda")?true:false;
    boolean r=(choice3.getSelectedItem()=="prawda")?true:false;
    boolean w;
    boolean error=false;
    switch(choice2.getSelectedIndex())
    {
      case 0: w=l && r; break;
      case 1: w=l || r; break;
      case 2: w=l ^ r; break;
      case 3: w=implikacja(l,r); break;
      case 4: w=(l==r); break;
      default: w=false; error=true;
    }
    if (!error) textField1.setText(w?"prawda":"fasz"); else textField1.setText("Bd!");
  }
}

class OperacjeLogiczne_choice1_itemAdapter implements java.awt.event.ItemListener {
  OperacjeLogiczne adaptee;

  OperacjeLogiczne_choice1_itemAdapter(OperacjeLogiczne adaptee) {
    this.adaptee = adaptee;
  }
  public void itemStateChanged(ItemEvent e) {
    adaptee.choice1_itemStateChanged(e);
  }
}

class OperacjeLogiczne_choice2_itemAdapter implements java.awt.event.ItemListener {
  OperacjeLogiczne adaptee;

  OperacjeLogiczne_choice2_itemAdapter(OperacjeLogiczne adaptee) {
    this.adaptee = adaptee;
  }
  public void itemStateChanged(ItemEvent e) {
    adaptee.choice1_itemStateChanged(e);
  }
}

class OperacjeLogiczne_choice3_itemAdapter implements java.awt.event.ItemListener {
  OperacjeLogiczne adaptee;

  OperacjeLogiczne_choice3_itemAdapter(OperacjeLogiczne adaptee) {
    this.adaptee = adaptee;
  }
  public void itemStateChanged(ItemEvent e) {
    adaptee.choice1_itemStateChanged(e);
  }
}
