package helion.r2;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class UlamekDemo extends Applet {

  final int dupa = 0;

  KlasaAbstrakcyjna kz = new KlasaZewnetrzna();
  KlasaAbstrakcyjna kw = new KlasaWewnetrzna();
  KlasaAbstrakcyjna ka = new KlasaAbstrakcyjna()
  {
    public String przedstawSie()
    {
      return "Klasa anonimowa";
    }
  };

  private boolean isStandalone = false;
  List list1 = new List();
  Button button1 = new Button();
  //Get a parameter value
  public String getParameter(String key, String def)
  {
    return isStandalone ? System.getProperty(key, def) :
        (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public UlamekDemo()
  {
  }

  //Initialize the applet
  public void init()
  {
    try
    {
      jbInit();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception
  {
    this.setLayout(null);
    list1.setFont(new java.awt.Font("Dialog", 0, 20));
    list1.setBounds(new Rectangle(37, 19, 314, 207));
    button1.setLabel("button1");
    button1.setBounds(new Rectangle(36, 245, 316, 36));
    button1.addActionListener(new UlamekDemo_button1_actionAdapter(this));
    this.add(list1, null);
    this.add(button1, null);
  }

  //Get Applet information
  public String getAppletInfo()
  {
    return "Applet Information";
  }

  //Get parameter info
  public String[][] getParameterInfo()
  {
    return null;
  }

  void button1_actionPerformed(ActionEvent e)
  {
    char b = 56;
    list1.add("" + b);

    class KlasaLokalna
        extends KlasaAbstrakcyjna
    {
      public String przedstawSie()
      {
        return "Klasa lokalna";
      }
    }

    KlasaAbstrakcyjna kz = new KlasaZewnetrzna();
    KlasaAbstrakcyjna kw = new KlasaWewnetrzna();
    KlasaAbstrakcyjna kl = new KlasaLokalna();
    KlasaAbstrakcyjna ka = new KlasaAbstrakcyjna()
    {
      public String przedstawSie()
      {
        return "Klasa anonimowa";
      }
    };

    list1.add(kz.przedstawSie());
    list1.add(kw.przedstawSie());
    list1.add(kl.przedstawSie());
    list1.add(ka.przedstawSie());

    list1.add(new KlasaStosujacaInterfejs().przedstawSie());
  }
}

  class KlasaWewnetrzna extends KlasaAbstrakcyjna
  {
    public String przedstawSie(){return "Klasa wewntrzna";}
  }

class UlamekDemo_button1_actionAdapter implements java.awt.event.ActionListener {
  UlamekDemo adaptee;

  UlamekDemo_button1_actionAdapter(UlamekDemo adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.button1_actionPerformed(e);
  }
}

abstract class KlasaAbstrakcyjna
{
  abstract String przedstawSie(); //{return "";};
}

class KlasaZewnetrzna extends KlasaAbstrakcyjna
{
  public String przedstawSie(){return "Klasa zewntrzna";}
}

interface Grzeczny
{
  public String przedstawSie();
}

class KlasaStosujacaInterfejs implements Grzeczny
{
  public String przedstawSie(){return "Grzeczna klasa";}
}

class UlamekTablica implements Cloneable
{
  public int[] lm=new int[2];

  public Object clone() throws CloneNotSupportedException
  {

    try
    {
      Object wynik=super.clone();
      int[] nowe_lm=new int[2];
      nowe_lm[0]=this.lm[0];
      nowe_lm[1]=this.lm[1];
      ((UlamekTablica)wynik).lm=nowe_lm;
      return wynik;
    }
    catch(CloneNotSupportedException exc)
    {
      throw exc;
    }
  }

}
