package helion.r3;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

//URL
import java.net.URL;

//PixelGrabber
import java.awt.image.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class JPictureView_Frame extends JFrame {
  JPanel contentPane;
  JToolBar jToolBar = new JToolBar();
  JButton jButton1 = new JButton();
  JButton jButton2 = new JButton();
  JButton jButton3 = new JButton();
  ImageIcon image1;
  ImageIcon image2;
  ImageIcon closeImage;

  //Construct the frame
  public JPictureView_Frame()
  {
    System.out.println("Tworzenie okna ...");
    this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().
        getResource("JPictureView.gif")));
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try
    {
      jbInit();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception
  {
    System.out.println("Tworzenie komponentw interfejsu ...");
    image1 = new ImageIcon(helion.r3.JPictureView_Frame.class.getResource(
        "openFile.png"));
    image2 = new ImageIcon(helion.r3.JPictureView_Frame.class.getResource(
        "closeFile.png"));
    //closeImage = new ImageIcon("classes/helion/r4/close.gif");
    //closeImage = new ImageIcon(helion.r4.JPictureView_Frame.class.getResource("close.gif"));
    closeImage = new ImageIcon(this.getClass().getResource("close.gif"));
    contentPane = (JPanel)this.getContentPane();
    contentPane.setLayout(null);
    this.setSize(new Dimension(400, 300));
    this.setTitle("JPictureView");
    jButton1.setIcon(image1);
    jButton1.setText("Otwrz plik ...");
    jButton1.addActionListener(new JPictureView_Frame_jButton1_actionAdapter(this));
    jButton1.setToolTipText("Otwrz plik ...");
    jButton2.setIcon(image2);
    jButton2.setText("");
    jButton2.addActionListener(new JPictureView_Frame_jButton2_actionAdapter(this));
    jButton2.setToolTipText("Usu obraz");
    jToolBar.setDebugGraphicsOptions(0);
    jToolBar.setBounds(new Rectangle(0, 0, 400, 31));
    jButton3.setMinimumSize(new Dimension(57, 29));
    jButton3.setToolTipText("Zamknij aplikacj");
    jButton3.setIcon(closeImage);
    jButton3.setText("Zamknij");
    jButton3.addActionListener(new JPictureView_Frame_jButton3_actionAdapter(this));
    jToolBar.add(jButton1);
    jToolBar.add(jButton2);
    jToolBar.add(jButton3, null);
    contentPane.add(jToolBar, null);
    //dodany filtr do okna diaogowego
    jFileChooser1.setFileFilter(new javax.swing.filechooser.FileFilter()
    {
      public boolean accept(java.io.File f)
      {
        return f.isDirectory() || f.getPath().endsWith(".gif") ||
            f.getPath().endsWith(".jpeg") || f.getPath().endsWith(".jpg") ||
            f.getPath().endsWith(".png");
      }

      public String getDescription()
      {
        return "Pliki graficzne (*.gif,*.jpg,*.png)";
      }
    });

  }

  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING)
    {
      System.exit(0);
    }
  }

  Image obraz = null;
  JFileChooser jFileChooser1 = new JFileChooser();
  void jButton1_actionPerformed(ActionEvent e)
  {
    System.out.println("Wczytywanie obrazu ...");
    //JFileChooser jFileChooser1 = new JFileChooser();
    if (jFileChooser1.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
    {
      String nazwa_pliku = jFileChooser1.getSelectedFile().getAbsolutePath();

      //wczytywanie obrazka
      try
      {
        URL adres_pliku = new URL("file", null, nazwa_pliku);
        obraz = Toolkit.getDefaultToolkit().getImage(adres_pliku);
        //w aplecie: Image obrazek = this.getImage(new java.net.URL("file",null,nazwa_pliku));
        this.setTitle("JPictureView - " + nazwa_pliku);
        this.repaint();
        System.out.println("Prba wczytania obrazu z pliku " + nazwa_pliku);
      }
      catch (java.io.IOException exc)
      {
        System.err.println("Bd: " + exc.getMessage());
        JOptionPane.showMessageDialog(this, "Bd: " + exc.getMessage(),
                                      "Informacja o bdzie", 0);
      }
    }
  }

  public void paint(Graphics g)
  {
    //System.out.println("Odwieanie okna ...");
    super.paint(g); //to takze czyszci okno aplikacji
    if (obraz != null)
    {
      int szerokosc_brzegu_okna = (this.getWidth() - contentPane.getWidth()) /
          2;
      int wysokosc_paska_tytulu = this.getHeight() - contentPane.getHeight() -
          szerokosc_brzegu_okna;
      g.drawImage(obraz, szerokosc_brzegu_okna,
                  wysokosc_paska_tytulu + jToolBar.getHeight(), this);
      jToolBar.repaint();
      //for (int i=0; i<this.getContentPane().getComponentCount(); i++) if (this.getContentPane().getComponent(i).isLightweight()) this.getContentPane().getComponent(i).repaint();
    }
  }

  /*
     //tylko do celw demonstracyjnych
     public void paint(Graphics g)
     {
    super.paint(g); //to takze czyszci okno aplikacji
    if (obraz!=null)
    {
      int wysokosc_paska_tytulu=this.getHeight()-contentPane.getHeight();
      g.drawImage(obraz,0,wysokosc_paska_tytulu,this);
      //jToolBar.repaint();
    }
     }
   */

  void jButton2_actionPerformed(ActionEvent e)
  {
    System.out.println("Kasowanie obrazu ...");
    obraz = null;
    this.setTitle("JPictureView");
    this.repaint();
  }

  void jButton3_actionPerformed(ActionEvent e)
  {
    System.out.println("Zamykanie aplikacji ...");
    //System.exit(0); //zamkniecie aplikacji
    this.dispose(); //zamkniecie okna
  }
}

  class JPictureView_Frame_jButton1_actionAdapter
      implements java.awt.event.ActionListener
  {
    JPictureView_Frame adaptee;

    JPictureView_Frame_jButton1_actionAdapter(JPictureView_Frame adaptee)
    {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e)
    {
      adaptee.jButton1_actionPerformed(e);
    }
  }

  class JPictureView_Frame_jButton2_actionAdapter
      implements java.awt.event.ActionListener
  {
    JPictureView_Frame adaptee;

    JPictureView_Frame_jButton2_actionAdapter(JPictureView_Frame adaptee)
    {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e)
    {
      adaptee.jButton2_actionPerformed(e);
    }
  }

  class JPictureView_Frame_jButton3_actionAdapter
      implements java.awt.event.ActionListener
  {
    JPictureView_Frame adaptee;

    JPictureView_Frame_jButton3_actionAdapter(JPictureView_Frame adaptee)
    {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e)
    {
      adaptee.jButton3_actionPerformed(e);
    }
  }
