package helion.r3;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import com.borland.dbswing.*;

//obsluga plikow
import java.io.*;

//schowek
//import java.awt.datatransfer.*;

//Filtry
import javax.swing.filechooser.FileFilter;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class Notatnik_Frame extends JFrame {
  JPanel contentPane;
  JMenuBar jMenuBar1 = new JMenuBar();
  JMenu jMenuFile = new JMenu();
  JMenuItem jMenuFileExit = new JMenuItem();
  JMenu jMenuHelp = new JMenu();
  JMenuItem jMenuHelpAbout = new JMenuItem();
  JLabel statusBar = new JLabel();
  BorderLayout borderLayout1 = new BorderLayout();
  JMenuItem jMenuItem1 = new JMenuItem();
  JMenuItem jMenuItem2 = new JMenuItem();
  JMenu jMenu1 = new JMenu();
  JMenuItem jMenuItem3 = new JMenuItem();
  JMenuItem jMenuItem4 = new JMenuItem();
  JMenuItem jMenuItem5 = new JMenuItem();
  JMenuItem jMenuItem6 = new JMenuItem();
  JMenuItem jMenuItem7 = new JMenuItem();
  JScrollPane jScrollPane1 = new JScrollPane();
  JFileChooser jFileChooser1 = new JFileChooser();
  //Clipboard schowek=this.getToolkit().getSystemClipboard();
  //Clipboard schowek=new Clipboard("notatnik");
  JMenu jMenu2 = new JMenu();
  JMenuItem jMenuItem9 = new JMenuItem();
  JMenuItem jMenuItem10 = new JMenuItem();
  JMenuItem jMenuItem11 = new JMenuItem();
  JCheckBoxMenuItem jCheckBoxMenuItem1 = new JCheckBoxMenuItem();
  FontChooser fontChooser1 = new FontChooser();
  JPopupMenu jPopupMenu1 = new JPopupMenu();
  JMenuItem jMenuItem8 = new JMenuItem();
  JMenuItem jMenuItem12 = new JMenuItem();
  JMenuItem jMenuItem13 = new JMenuItem();
  JMenuItem jMenuItem14 = new JMenuItem();
  JEditorPane jEditorPane1 = new JEditorPane();

  //Construct the frame
  public Notatnik_Frame() {
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception  {
    contentPane = (JPanel) this.getContentPane();
    contentPane.setLayout(borderLayout1);
    this.setSize(new Dimension(640, 480));
    this.setTitle("Notatnik");
    statusBar.setFont(new java.awt.Font("Dialog", 0, 16));
    statusBar.setText(" ");
    jMenuFile.setText("Plik");
    jMenuFileExit.setText("Zakocz");
    jMenuFileExit.addActionListener(new Notatnik_Frame_jMenuFileExit_ActionAdapter(this));
    jMenuHelp.setText("Pomoc");
    jMenuHelpAbout.setSelected(false);
    jMenuHelpAbout.setText("O ...");
    jMenuHelpAbout.addActionListener(new Notatnik_Frame_jMenuHelpAbout_ActionAdapter(this));
    jMenuItem1.setToolTipText("");
    jMenuItem1.setActionCommand("");
    jMenuItem1.setText("Otwrz ...");
    jMenuItem1.setAccelerator(javax.swing.KeyStroke.getKeyStroke('O', java.awt.event.KeyEvent.CTRL_MASK, false));
    jMenuItem1.addActionListener(new Notatnik_Frame_jMenuItem1_actionAdapter(this));
    jMenuItem2.setText("Zapisz ...");
    jMenuItem2.setAccelerator(javax.swing.KeyStroke.getKeyStroke('S', java.awt.event.KeyEvent.CTRL_MASK, false));
    jMenuItem2.addActionListener(new Notatnik_Frame_jMenuItem2_actionAdapter(this));
    jMenu1.setText("Edycja");
    jMenuItem3.setEnabled(true);
    jMenuItem3.setText("Kopiuj");
    jMenuItem3.addActionListener(new Notatnik_Frame_jMenuItem3_actionAdapter(this));
    jMenuItem5.setEnabled(true);
    jMenuItem5.setText("Wytnij");
    jMenuItem5.addActionListener(new Notatnik_Frame_jMenuItem5_actionAdapter(this));
    jMenuItem4.setEnabled(true);
    jMenuItem4.setText("Wklej");
    jMenuItem4.addActionListener(new Notatnik_Frame_jMenuItem4_actionAdapter(this));
    jMenuItem6.setEnabled(true);
    jMenuItem6.setText("Usu");
    jMenuItem6.addActionListener(new Notatnik_Frame_jMenuItem6_actionAdapter(this));
    jMenuItem7.setEnabled(true);
    jMenuItem7.setText("Zaznacz wszystko");
    jMenuItem7.addActionListener(new Notatnik_Frame_jMenuItem7_actionAdapter(this));
    jFileChooser1.setBackground(Color.black);
    jFileChooser1.setFont(new java.awt.Font("SansSerif", 0, 17));
    jFileChooser1.setOpaque(false);
    jFileChooser1.setToolTipText("");
    jFileChooser1.setCurrentDirectory(katalogBiezacy);
    jFileChooser1.setDialogTitle("Otwrz");
    jFileChooser1.setDialogType(0);
    jFileChooser1.setFileFilter(null);
    jMenu2.setText("Widok");
    jMenuItem9.setText("Czcionka ...");
    jMenuItem9.addActionListener(new Notatnik_Frame_jMenuItem9_actionAdapter(this));
    jMenuItem10.setText("Kolor czcionki ...");
    jMenuItem10.addActionListener(new Notatnik_Frame_jMenuItem10_actionAdapter(this));
    jMenuItem11.setText("Kolor ta ...");
    jMenuItem11.addActionListener(new Notatnik_Frame_jMenuItem11_actionAdapter(this));
    jCheckBoxMenuItem1.setSelected(false);
    jCheckBoxMenuItem1.setText("Pasek stanu");
    jCheckBoxMenuItem1.setState(true);
    jCheckBoxMenuItem1.addActionListener(new Notatnik_Frame_jCheckBoxMenuItem1_actionAdapter(this));
    fontChooser1.setFrame(this);
    fontChooser1.setTitle("Wybierz czcionk");
    fontChooser1.setSampleText("Za gl ja. 1234567890");
    jMenuItem8.setText("Kopiuj");
    jMenuItem8.addActionListener(new Notatnik_Frame_jMenuItem8_actionAdapter(this));
    jMenuItem12.setText("Wytnij");
    jMenuItem12.addActionListener(new Notatnik_Frame_jMenuItem12_actionAdapter(this));
    jMenuItem13.setText("Wklej");
    jMenuItem13.addActionListener(new Notatnik_Frame_jMenuItem13_actionAdapter(this));
    jMenuItem14.setText("Usu");
    jMenuItem14.addActionListener(new Notatnik_Frame_jMenuItem14_actionAdapter(this));
    jEditorPane1.addMouseListener(new Notatnik_Frame_jEditorPane1_mouseAdapter(this));
    jEditorPane1.setFont(new java.awt.Font("Dialog", 0, 16));
    jMenuFile.add(jMenuItem1);
    jMenuFile.add(jMenuItem2);
    jMenuFile.addSeparator();
    jMenuFile.add(jMenuFileExit);
    jMenuHelp.add(jMenuHelpAbout);
    jMenuBar1.add(jMenuFile);
    jMenuBar1.add(jMenu1);
    jMenuBar1.add(jMenu2);
    jMenuBar1.add(jMenuHelp);
    this.setJMenuBar(jMenuBar1);
    contentPane.add(statusBar, BorderLayout.SOUTH);
    contentPane.add(jScrollPane1, BorderLayout.CENTER);
    jScrollPane1.getViewport().add(jEditorPane1, null);
    jMenu1.add(jMenuItem3);
    jMenu1.add(jMenuItem5);
    jMenu1.add(jMenuItem4);
    jMenu1.add(jMenuItem6);
    jMenu1.addSeparator();
    jMenu1.add(jMenuItem7);
    jMenu2.add(jCheckBoxMenuItem1);
    jMenu2.add(jMenuItem9);
    jMenu2.add(jMenuItem10);
    jMenu2.add(jMenuItem11);
    jPopupMenu1.add(jMenuItem8);
    jPopupMenu1.add(jMenuItem12);
    jPopupMenu1.add(jMenuItem13);
    jPopupMenu1.add(jMenuItem14);
    //Filtry (dodane recznie)
    jFileChooser1.removeChoosableFileFilter(jFileChooser1.getChoosableFileFilters()[0]);
    jFileChooser1.addChoosableFileFilter(filtrTXT);
    jFileChooser1.addChoosableFileFilter(filtrHTML);
    jFileChooser1.addChoosableFileFilter(filtrWSZYSTKIE);
    jFileChooser1.setFileFilter(filtrTXT);
  }

  //File | Exit action performed
  public void jMenuFileExit_actionPerformed(ActionEvent e) {
    System.exit(0);
  }

  //Help | About action performed
  public void jMenuHelpAbout_actionPerformed(ActionEvent e) {
    Notatnik_Frame_AboutBox dlg = new Notatnik_Frame_AboutBox(this);
    Dimension dlgSize = dlg.getPreferredSize();
    Dimension frmSize = getSize();
    Point loc = getLocation();
    dlg.setLocation((frmSize.width - dlgSize.width) / 2 + loc.x, (frmSize.height - dlgSize.height) / 2 + loc.y);
    dlg.setModal(true);
    dlg.pack();
    dlg.show();
  }

  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e) {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING) {
      jMenuFileExit_actionPerformed(null);
    }
  }

/*
  //wersja 1
  void jMenuItem1_actionPerformed(ActionEvent e)
  {
    try
    {
      //String nazwa_pliku="c:\\helion\\przyklad.txt";
      String nazwa_pliku="c:/helion/przyklad.txt";
      //String nazwa_pliku="~/helion/przyklad.txt";  //Linux, Solaris
      java.net.URL adres_pliku=new java.net.URL("file",null,nazwa_pliku);
      jEditorPane1.setPage(adres_pliku);
      statusBar.setText("Plik: "+nazwa_pliku);
      this.setTitle("Notatnik - "+nazwa_pliku);
    }
    catch(java.io.IOException exc)
    {
      statusBar.setText("Blad: "+exc.getMessage());
    }
  }
 */

//pola dodatkowe do wersji 2 i 3
private File katalogBiezacy=new File(".");
private FileFilter filtrTXT=new FileFilter()
    {
      public boolean accept(File f) {return f.isDirectory() || f.getPath().endsWith(".txt");}
      public String getDescription() {return "Pliki tekstowe (*.txt)";}
    };
private FileFilter filtrHTML=new FileFilter()
    {
      public boolean accept(File f) {return f.isDirectory() || f.getPath().endsWith(".html") || f.getPath().endsWith(".htm");}
      public String getDescription() {return "Pliki HTML (*.html,*.htm)";}
    };
private FileFilter filtrWSZYSTKIE=new FileFilter()
    {
      public boolean accept(File f) {return true;}
      public String getDescription() {return "Wszystkie pliki";}
    };

/*
//wersja 2 (okna dialogowe)
void jMenuItem1_actionPerformed(ActionEvent e)
{
  try
  {
    if (jFileChooser1.showOpenDialog(this)==JFileChooser.APPROVE_OPTION)
    {
      String nazwa_pliku=jFileChooser1.getSelectedFile().getAbsolutePath();
      java.net.URL adres_pliku=new java.net.URL("file",null,nazwa_pliku);
      jEditorPane1.setPage(adres_pliku);
      statusBar.setText("Plik: "+nazwa_pliku);
      this.setTitle("Notatnik - "+nazwa_pliku);
    }
  }
  catch(java.io.IOException exc)
  {
    statusBar.setText("Blad: "+exc.getMessage());
    JOptionPane.showMessageDialog(null,"Bd: "+exc.getMessage(),"Informacja o bdzie",JOptionPane.ERROR_MESSAGE);
  }
}
*/

/*
  //wersja 3 (FileReader)
  void jMenuItem1_actionPerformed(ActionEvent e)
  {
    try
    {
      if (jFileChooser1.showOpenDialog(this)==JFileChooser.APPROVE_OPTION)
      {
        String nazwa_pliku=jFileChooser1.getSelectedFile().getAbsolutePath();
        FileReader plik_we = new FileReader(nazwa_pliku);
        int litera;
        String tekst = "";
        while ( (litera = plik_we.read()) != -1) tekst += (char) litera;
        jEditorPane1.setText(tekst);
        plik_we.close();
        statusBar.setText("Plik: "+nazwa_pliku);
        this.setTitle("Notatnik - "+nazwa_pliku);
      }
    }
    catch(java.io.IOException exc)
    {
      statusBar.setText("Blad: "+exc.getMessage());
      JOptionPane.showMessageDialog(null,"Bd: "+exc.getMessage(),"Informacja o bdzie",JOptionPane.ERROR_MESSAGE);
    }
  }
*/

  //wersja 4 (metoda czytajPlikTekstowy)
  public static String czytajPlikTekstowy(String nazwa_pliku) throws java.io.IOException
  {
    try
    {
      FileReader plik_we = new FileReader(nazwa_pliku);
      int litera;
      String tekst = "";
      while ( (litera = plik_we.read()) != -1) tekst += (char) litera;
      plik_we.close();
      return tekst;
    }
    catch(java.io.IOException exc)
    {
      throw exc;
    }
  }

  //wersja 4
  void jMenuItem1_actionPerformed(ActionEvent e)
  {
    try
    {
      if (jFileChooser1.showOpenDialog(this)==JFileChooser.APPROVE_OPTION)
      {
        String nazwa_pliku=jFileChooser1.getSelectedFile().getAbsolutePath();
        jEditorPane1.setText(czytajPlikTekstowy(nazwa_pliku));
        statusBar.setText("Plik: "+nazwa_pliku);
        this.setTitle("Notatnik - "+nazwa_pliku);
      }
    }
    catch(java.io.IOException exc)
    {
      statusBar.setText("Blad: "+exc.getMessage());
      JOptionPane.showMessageDialog(null,"Bd: "+exc.getMessage(),"Informacja o bdzie",JOptionPane.ERROR_MESSAGE);
    }
  }

/*
//wersja 1
  void jMenuItem2_actionPerformed(ActionEvent e) {
    jFileChooser1.setDialogTitle("Zapisz");
    if (jFileChooser1.showSaveDialog(this)==JFileChooser.APPROVE_OPTION)
    {
      String nazwa_pliku=jFileChooser1.getSelectedFile().getAbsolutePath();

      try
      {
        //FileWriter plik_wy = new FileWriter(new File(nazwa_pliku));
        FileWriter plik_wy = new FileWriter(nazwa_pliku);
        plik_wy.write(jEditorPane1.getText());
        plik_wy.close();

        statusBar.setText("Zapisuj do pliku: "+nazwa_pliku);
      }
      catch (IOException exc)
      {
        statusBar.setText("Bd: "+exc.getMessage());
        JOptionPane.showMessageDialog(this,"Bd: "+exc.getMessage(),"Informacja o bdzie",0);
      }
    }
  }
 */

//wersja 2 (zapiszDoPlikuTekstowego)
public static void zapiszDoPlikuTekstowego(String nazwa_pliku,String tekst) throws java.io.IOException
  {
    try
    {
      FileWriter plik_wy = new FileWriter(nazwa_pliku);
      plik_wy.write(tekst);
      plik_wy.close();
    }
    catch(java.io.IOException exc)
    {
      throw exc;
    }
  }

void jMenuItem2_actionPerformed(ActionEvent e) {
  jFileChooser1.setDialogTitle("Zapisz");
  if (jFileChooser1.showSaveDialog(this)==JFileChooser.APPROVE_OPTION)
  {
    String nazwa_pliku=jFileChooser1.getSelectedFile().getAbsolutePath();

    try
    {
      zapiszDoPlikuTekstowego(nazwa_pliku,jEditorPane1.getText());
      statusBar.setText("Zapisuj do pliku: "+nazwa_pliku);
    }
    catch (IOException exc)
    {
      statusBar.setText("Bd: "+exc.getMessage());
      JOptionPane.showMessageDialog(this,"Bd: "+exc.getMessage(),"Informacja o bdzie",0);
    }
  }
}


  void jMenuItem3_actionPerformed(ActionEvent e)
  {
    jEditorPane1.copy();

    /*
    String zaznaczony_tekst=jEditorPane1.getSelectedText();
    if (zaznaczony_tekst==null) return; //warunkowe opuszczenie funkcji
    Strin tekst_schowek=new StringSelection(zaznaczony_tekst);
    schowek.setContents(tekst_schowek,tekst_schowek);
    statusBar.setText("Zaznaczony fragment zosta skopiowany do schowka");
    */
  }

  void jMenuItem4_actionPerformed(ActionEvent e)
  {
    jEditorPane1.paste();

    /*
    Transferable tekst_schowek=schowek.getContents(this);
    try
    {
      String tekst = (String) tekst_schowek.getTransferData(DataFlavor.stringFlavor);
      jEditorPane1.replaceSelection(tekst);
      statusBar.setText("Zawartoc schowka zostaa wklejona do edytora");
    }
    catch(Exception exc)
    {
      statusBar.setText("Bd: "+exc.getMessage());
      JOptionPane.showMessageDialog(this,"Bd: "+exc.getMessage(),"Informacja o bdzie",0);
    }
    */
  }

  void jMenuItem5_actionPerformed(ActionEvent e) {
    jEditorPane1.cut();

    /*
    String zaznaczony_tekst=jEditorPane1.getSelectedText();
    if (zaznaczony_tekst==null) return; //warunkowe opuszczenie funkcji
    StringSelection tekst_schowek=new StringSelection(zaznaczony_tekst);
    schowek.setContents(tekst_schowek,tekst_schowek);
    jEditorPane1.replaceSelection(""); //usuwanie zaznaczonej czesci
    statusBar.setText("Zaznaczony fragment zosta przeniesiony do schowka");
    */
  }

  void jMenuItem6_actionPerformed(ActionEvent e)
  {
    jEditorPane1.replaceSelection("");
  }

  void jMenuItem7_actionPerformed(ActionEvent e)
  {
    jEditorPane1.selectAll();
  }

  void jCheckBoxMenuItem1_actionPerformed(ActionEvent e) {
    statusBar.setVisible(jCheckBoxMenuItem1.getState());
  }

  void jMenuItem10_actionPerformed(ActionEvent e) {
    /*
    Color kolor_stary=jEditorPane1.getForeground();
    Color kolor_nowy=JColorChooser.showDialog(this,"Kolor czcionki",kolor_stary);
    jEditorPane1.setForeground(kolor_nowy);
    */

    jEditorPane1.setForeground(JColorChooser.showDialog(this,"Kolor czcionki",jEditorPane1.getForeground()));
  }

  void jMenuItem11_actionPerformed(ActionEvent e) {
      /*
      Color kolor_stary=jEditorPane1.getBackground();
      Color kolor_nowy=JColorChooser.showDialog(this,"Kolor ta",kolor_stary);
      jEditorPane1.setBackground(kolor_nowy);
      */

      jEditorPane1.setBackground(JColorChooser.showDialog(this,"Kolor ta",jEditorPane1.getBackground()));
  }

  void jMenuItem9_actionPerformed(ActionEvent e) {
    fontChooser1.setSelectedFont(jEditorPane1.getFont());
    //if (jEditorPane1.getText().length()>10) fontChooser1.setSampleText(jEditorPane1.getText());
    if (fontChooser1.showDialog()) jEditorPane1.setFont(fontChooser1.getSelectedFont());
  }

  void jEditorPane1_mousePressed(MouseEvent e)
  {
    if (e.getButton()==e.BUTTON3) jPopupMenu1.show(jEditorPane1,e.getX(),e.getY());
  }
}

class Notatnik_Frame_jMenuFileExit_ActionAdapter implements ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuFileExit_ActionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuFileExit_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuHelpAbout_ActionAdapter implements ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuHelpAbout_ActionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuHelpAbout_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem1_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem1_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem1_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem2_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem2_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem2_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem3_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem3_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem3_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem4_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem4_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem4_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem5_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem5_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem5_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem6_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem6_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem6_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem7_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem7_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem7_actionPerformed(e);
  }
}

class Notatnik_Frame_jCheckBoxMenuItem1_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jCheckBoxMenuItem1_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jCheckBoxMenuItem1_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem10_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem10_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem10_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem11_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem11_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem11_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem9_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem9_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem9_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem8_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem8_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem3_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem12_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem12_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem5_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem13_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem13_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem4_actionPerformed(e);
  }
}

class Notatnik_Frame_jMenuItem14_actionAdapter implements java.awt.event.ActionListener {
  Notatnik_Frame adaptee;

  Notatnik_Frame_jMenuItem14_actionAdapter(Notatnik_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jMenuItem6_actionPerformed(e);
  }
}

class Notatnik_Frame_jEditorPane1_mouseAdapter extends java.awt.event.MouseAdapter
{
  Notatnik_Frame adaptee;

  Notatnik_Frame_jEditorPane1_mouseAdapter(Notatnik_Frame adaptee)
  {
    this.adaptee = adaptee;
  }
  public void mousePressed(MouseEvent e)
  {
    adaptee.jEditorPane1_mousePressed(e);
  }
}
