package helion.r6;

import java.awt.Button;
import java.awt.HeadlessException;

//Color
import java.awt.Color;
import java.awt.SystemColor;

//Vector
import java.util.Vector;

/**
* Komponent MigajacyPrzycisk implementuje zwyky przycisk z wszystkimi jego
* wasnociami i metodami dodajc cykliczn zamian koloru napisu i ta
* z okrelanym przez uytkownika okresem i opnieniem.
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class MigajacyPrzycisk extends Button implements Runnable
{
  private Thread watek=null;
  private long okres=1000;
  private long opoznienie=3000;

  public MigajacyPrzycisk() //throws HeadlessException
  {
    uruchomWatek();
  }

  public MigajacyPrzycisk(String label) //throws HeadlessException
  {
    super(label);
    uruchomWatek();
  }

  private void uruchomWatek()
  {
    watek=new Thread(this);
    watek.start();
  }

  public void run()
  {
    try {watek.sleep(opoznienie);}
    catch(InterruptedException exc){System.err.println(exc.getMessage());}
    wywolajMiganieRozpoczete(new MiganieEvent(this));

    while(watek!=null)
      {
        Color kolorNapisu=this.getForeground();
        Color kolorTla=this.getBackground();

        this.setForeground(kolorTla);
        this.setBackground(kolorNapisu);
        wywolajMiganieMigniecie(new MiganieEvent(this));
        try {watek.sleep(okres);}
        catch(InterruptedException exc){System.err.println(exc.getMessage());}
      }

    wywolajMiganieZakonczone(new MiganieEvent(this));
  }

  /**
     * Zwraca dugo okresu migania przycisku.
     * @return dugo okresu w milisekundach
     * @see #setOkres
     * @since wersja 1.0
     */
  public long getOkres() {
    return okres;
  }

  /**
     * Ustala dugo okresu migania przycisku.
     * @param okres okrela dugo okresu w milisekundach
     * @see #getOkres
     * @since wersja 1.0
     */
  public void setOkres(long okres) {
    this.okres = okres;
  }

  /**
     * Zwraca dugo opnienia po inicjacji do rozpoczcia migania przycisku.
     * @return dugo opnienia w milisekundach;
     * @see #setOpoznienie
     * @since wersja 1.0
     */
  public long getOpoznienie() {
    return opoznienie;
  }

  /**
   * Ustala dugo opnienia po inicjacji do rozpoczcia migania przycisku.
   * @param opoznienie okrela dugo okresu w milisekundach;
   * @see #getOpoznienie
   * @since wersja 1.0
   */
  public void setOpoznienie(long opoznienie) {
    this.opoznienie = opoznienie;
  }

  /**
   * W zalenoci od wartoci argumentu wcza lub wycza miganie przycisku.
   * @param miganieWlaczone argument okrela dugo okresu w milisekundach
   * @see #getOpoznienie
   * @since wersja 1.0
   */
  public void setMiganieWlaczone(boolean miganieWlaczone)
  {
    if (miganieWlaczone)
    {
      if (watek==null) uruchomWatek();
    }
    else
    {
      watek = null;
      //wywolajMiganieZakonczone(new MiganieEvent(this));
    }
  }

  /**
     * Zwraca warto <code>true</code> jeeli miganie przycisku jest wczone
     * i <code>false</code> jeeli jest wyczone.
     * @return warto logiczna okrelajca czy miganie przycisku jest wczone;
     * @see #setMiganieWlaczone
     * @since wersja 1.0
     */
  public boolean getMiganieWlaczone()
  {
    return (watek!=null);
  }


  //Obs-uga zdarzenia (trzeba bylo zaimportowac Vector)
  private /*transient*/ Vector listaMiganieListener;

  public synchronized void addMiganieListener(MiganieListener listener)
  {
    if (listaMiganieListener==null) listaMiganieListener=new Vector(2);
    if (!listaMiganieListener.contains(listener)) listaMiganieListener.addElement(listener);
  }

  public synchronized void removeMiganieListener(MiganieListener listener)
  {
    if (listaMiganieListener!=null && listaMiganieListener.contains(listener)) listaMiganieListener.removeElement(listener);
  }

  protected void wywolajMiganieRozpoczete(MiganieEvent e)
  {
    if (listaMiganieListener == null) return;
    for (int i = 0; i < listaMiganieListener.size(); i++) ((MiganieListener) listaMiganieListener.elementAt(i)).miganieRozpoczete(e);
  }

  protected void wywolajMiganieZakonczone(MiganieEvent e)
  {
    if (listaMiganieListener == null) return;
    for (int i = 0; i < listaMiganieListener.size(); i++) ((MiganieListener) listaMiganieListener.elementAt(i)).miganieZakonczone(e);
  }

  protected void wywolajMiganieMigniecie(MiganieEvent e)
  {
    if (listaMiganieListener == null) return;
    for (int i = 0; i < listaMiganieListener.size(); i++) ((MiganieListener) listaMiganieListener.elementAt(i)).miganieMigniecie(e);
  }

}
