package helion.r6;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class MigajacyPrzyciskDemo extends Applet {
  private boolean isStandalone = false;

  MigajacyPrzycisk mp1=new MigajacyPrzycisk();
  MigajacyPrzycisk mp2=new MigajacyPrzycisk("Helion");
  MigajacyPrzycisk migajacyPrzycisk1 = new MigajacyPrzycisk();

  //Get a parameter value
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public MigajacyPrzyciskDemo() {
  }
  //Initialize the applet
  public void init() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  //Component initialization
  private void jbInit() throws Exception
  {
    this.setLayout(null);
    mp2.setBounds(new Rectangle(143, 25, 240, 87));
    mp2.setMiganieWlaczone(true);
    mp2.addActionListener(new MigajacyPrzyciskDemo_mp2_actionAdapter(this));
    mp1.setBounds(new Rectangle(28, 133, 172, 134));
    mp1.addMiganieListener(new MigajacyPrzyciskDemo_mp1_miganieAdapter(this));
    mp1.addActionListener(new MigajacyPrzyciskDemo_mp1_actionAdapter(this));
    mp1.setOkres(500);
    mp1.setOpoznienie(100);
    migajacyPrzycisk1.setLabel("migajacyPrzycisk1");
    migajacyPrzycisk1.setBounds(new Rectangle(256, 177, 84, 69));
    migajacyPrzycisk1.addActionListener(new MigajacyPrzyciskDemo_migajacyPrzycisk1_actionAdapter(this));
    migajacyPrzycisk1.setOkres(200);
    this.add(mp2);
    this.add(mp1);
    this.add(migajacyPrzycisk1, null);
  }
  //Start the applet
  public void start()
  {
    mp1.setMiganieWlaczone(true);
    mp2.setMiganieWlaczone(true);
    migajacyPrzycisk1.setMiganieWlaczone(true);
  }

  //Stop the applet
  public void stop()
  {
    mp1.setMiganieWlaczone(false);
    mp2.setMiganieWlaczone(false);
    migajacyPrzycisk1.setMiganieWlaczone(false);
  }

  //Destroy the applet
  public void destroy() {
  }
  //Get Applet information
  public String getAppletInfo() {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo() {
    return null;
  }

  void mp2_actionPerformed(ActionEvent e) {
    mp2.setForeground(Color.orange);
    mp2.setBackground(Color.pink);
  }

  void mp1_actionPerformed(ActionEvent e) {
    mp1.setForeground(Color.yellow);
    mp1.setBackground(Color.green);
  }

  void mp1_miganieMigniecie(MiganieEvent e)
  {
    MigajacyPrzycisk mp=(MigajacyPrzycisk)e.getSource();
    this.setBackground(mp.getForeground());
    this.setForeground(mp.getBackground());
  }

  void mp1_miganieRozpoczete(MiganieEvent e)
  {
    mp1.setLabel("Migam");
  }

  void mp1_miganieZakonczone(MiganieEvent e)
  {
    mp1.setLabel("Nie migam");
  }

  void migajacyPrzycisk1_actionPerformed(ActionEvent e)
  {
    mp1.setMiganieWlaczone(!mp1.getMiganieWlaczone());
  }



}

class MigajacyPrzyciskDemo_mp2_actionAdapter implements java.awt.event.ActionListener {
  MigajacyPrzyciskDemo adaptee;

  MigajacyPrzyciskDemo_mp2_actionAdapter(MigajacyPrzyciskDemo adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.mp2_actionPerformed(e);
  }
}

class MigajacyPrzyciskDemo_mp1_actionAdapter implements java.awt.event.ActionListener {
  MigajacyPrzyciskDemo adaptee;

  MigajacyPrzyciskDemo_mp1_actionAdapter(MigajacyPrzyciskDemo adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.mp1_actionPerformed(e);
  }
}

class MigajacyPrzyciskDemo_mp1_miganieAdapter implements helion.r6.MiganieListener {
  MigajacyPrzyciskDemo adaptee;

  MigajacyPrzyciskDemo_mp1_miganieAdapter(MigajacyPrzyciskDemo adaptee) {
    this.adaptee = adaptee;
  }
  public void miganieRozpoczete(MiganieEvent e) {
    adaptee.mp1_miganieRozpoczete(e);
  }
  public void miganieZakonczone(MiganieEvent e) {
    adaptee.mp1_miganieZakonczone(e);
  }
  public void miganieMigniecie(MiganieEvent e) {
    adaptee.mp1_miganieMigniecie(e);
  }
}

class MigajacyPrzyciskDemo_migajacyPrzycisk1_actionAdapter implements java.awt.event.ActionListener {
  MigajacyPrzyciskDemo adaptee;

  MigajacyPrzyciskDemo_migajacyPrzycisk1_actionAdapter(MigajacyPrzyciskDemo adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.migajacyPrzycisk1_actionPerformed(e);
  }
}
