package helion.r6.beansexpress;

import java.awt.*;
import java.util.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class MigajacyPrzycisk extends Button
{
  //BorderLayout borderLayout1 = new BorderLayout();

  private long okres;
  private long opoznienie;
  private Thread watek;
  private transient Vector miganieListeners;
  private boolean miganieWlaczone;

  class MiganieWatek extends Thread
  {
    //public MiganieWatek(){super();}
    public boolean konczenie=false;

    public void run()
    {
      try {this.sleep(opoznienie);}
      catch(InterruptedException exc){System.err.println(exc.getMessage());}
      fireMiganieRozpoczete(new MiganieEvent(this));

      while(!konczenie)
      {
        Color kolorNapisu=getForeground();
        Color kolorTla=getBackground();

        setForeground(kolorTla);
        setBackground(kolorNapisu);
        fireMiganieMigniecie(new MiganieEvent(this));
        try {this.sleep(okres);}
        catch(InterruptedException exc){System.err.println(exc.getMessage());}
      }
      fireMiganieZakonczone(new MiganieEvent(this));
    }
  }

  public MigajacyPrzycisk()
  {
    try
    {
      jbInit();
    }
    catch(Exception ex)
    {
      ex.printStackTrace();
    }
  }

  private void jbInit() throws Exception
  {
    //this.setLayout(borderLayout1);
    //setOkres(1000);
    //setOpoznienie(3000);
    //setMiganieWlaczone(true);
  }
  public long getOkres()
  {
    return okres;
  }
  public void setOkres(final long okres)
  {
    this.okres = okres;
  }
  public long getOpoznienie()
  {
    return opoznienie;
  }
  public void setOpoznienie(long opoznienie)
  {
    this.opoznienie = opoznienie;
  }
  public synchronized void removeMiganieListener(MiganieListener l)
  {
    if (miganieListeners != null && miganieListeners.contains(l))
    {
      Vector v = (Vector) miganieListeners.clone();
      v.removeElement(l);
      miganieListeners = v;
    }
  }
  public synchronized void addMiganieListener(MiganieListener l)
  {
    Vector v = miganieListeners == null ? new Vector(2) : (Vector) miganieListeners.clone();
    if (!v.contains(l))
    {
      v.addElement(l);
      miganieListeners = v;
    }
  }
  protected void fireMiganieRozpoczete(MiganieEvent e)
  {
    if (miganieListeners != null)
    {
      Vector listeners = miganieListeners;
      int count = listeners.size();
      for (int i = 0; i < count; i++)
      {
        ((MiganieListener) listeners.elementAt(i)).miganieRozpoczete(e);
      }
    }
  }
  protected void fireMiganieZakonczone(MiganieEvent e)
  {
    if (miganieListeners != null)
    {
      Vector listeners = miganieListeners;
      int count = listeners.size();
      for (int i = 0; i < count; i++)
      {
        ((MiganieListener) listeners.elementAt(i)).miganieZakonczone(e);
      }
    }
  }
  protected void fireMiganieMigniecie(MiganieEvent e)
  {
    if (miganieListeners != null)
    {
      Vector listeners = miganieListeners;
      int count = listeners.size();
      for (int i = 0; i < count; i++)
      {
        ((MiganieListener) listeners.elementAt(i)).miganieMigniecie(e);
      }
    }
  }
  public boolean isMiganieWlaczone() {
    return miganieWlaczone;
  }

/*
  //oryginalna
  public void setMiganieWlaczone(boolean miganieWlaczone) {
    this.miganieWlaczone = miganieWlaczone;
  }
*/

public void setMiganieWlaczone(boolean miganieWlaczone)
{
  this.miganieWlaczone = miganieWlaczone;

  if (miganieWlaczone)
  {
    if (watek==null)
    {
      watek=new MiganieWatek();
      watek.start();
      };
    }
    else
    {
        ((MiganieWatek)watek).konczenie = true;
        watek = null;
    }
  }

}
