package helion.r6.beansexpress;

import java.beans.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class MigajacyPrzyciskBeanInfo extends SimpleBeanInfo {
  Class beanClass = MigajacyPrzycisk.class;
  String iconColor16x16Filename = "MigajacyPrzycisk.gif";
  String iconColor32x32Filename = "MigajacyPrzycisk.gif";
  String iconMono16x16Filename = "MigajacyPrzycisk.gif";
  String iconMono32x32Filename = "MigajacyPrzycisk.gif";

  public MigajacyPrzyciskBeanInfo() {
  }
  public PropertyDescriptor[] getPropertyDescriptors() {
    try {
      PropertyDescriptor _miganieWlaczone = new PropertyDescriptor("miganieWlaczone", beanClass, "isMiganieWlaczone", "setMiganieWlaczone");
      _miganieWlaczone.setDisplayName("miganieWlaczone");
      _miganieWlaczone.setShortDescription("Okrela, czy miganie przycisku jest aktywne");
      PropertyDescriptor _okres = new PropertyDescriptor("okres", beanClass, "getOkres", "setOkres");
      _okres.setDisplayName("okres");
      _okres.setShortDescription("Okres migania przycisku");
      _okres.setPropertyEditorClass(helion.r6.beansexpress.EdytorOkres.class);
      PropertyDescriptor _opoznienie = new PropertyDescriptor("opoznienie", beanClass, "getOpoznienie", "setOpoznienie");
      _opoznienie.setDisplayName("opoznienie");
      _opoznienie.setShortDescription("Opnienie z jakim przycisk rozpoczyna miganie");
      PropertyDescriptor[] pds = new PropertyDescriptor[] {
        _miganieWlaczone,
        _okres,
        _opoznienie};
      return pds;
    }
    catch(IntrospectionException ex) {
      ex.printStackTrace();
      return null;
    }
  }
  public java.awt.Image getIcon(int iconKind) {
    switch (iconKind) {
      case BeanInfo.ICON_COLOR_16x16:
        return iconColor16x16Filename != null ? loadImage(iconColor16x16Filename) : null;
      case BeanInfo.ICON_COLOR_32x32:
        return iconColor32x32Filename != null ? loadImage(iconColor32x32Filename) : null;
      case BeanInfo.ICON_MONO_16x16:
        return iconMono16x16Filename != null ? loadImage(iconMono16x16Filename) : null;
      case BeanInfo.ICON_MONO_32x32:
        return iconMono32x32Filename != null ? loadImage(iconMono32x32Filename) : null;
    }
    return null;
  }
  public BeanInfo[] getAdditionalBeanInfo() {
    Class superclass = beanClass.getSuperclass();
    try {
      BeanInfo superBeanInfo = Introspector.getBeanInfo(superclass);
      return new BeanInfo[] { superBeanInfo };
    }
    catch(IntrospectionException ex) {
      ex.printStackTrace();
      return null;
    }
  }
}
