package helion.xb;

import java.awt.*;
import java.awt.event.*;
import javax.swing.*;

//URL
import java.net.URL;

//PixelGrabber
import java.awt.image.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class JPictureView_Frame extends JFrame {
  JPanel contentPane;
  JToolBar jToolBar = new JToolBar();
  JButton jButton1 = new JButton();
  JButton jButton2 = new JButton();
  JButton jButton3 = new JButton();
  JButton jButton4 = new JButton();
  ImageIcon image1;
  ImageIcon image2;
  ImageIcon closeImage;

  //Construct the frame
  public JPictureView_Frame()
  {
    System.out.println("Tworzenie okna ...");
    this.setIconImage(Toolkit.getDefaultToolkit().getImage(this.getClass().getResource("JPictureView.gif")));
    enableEvents(AWTEvent.WINDOW_EVENT_MASK);
    try
    {
      jbInit();
    }
    catch (Exception e)
    {
      e.printStackTrace();
    }
  }

  //Component initialization
  private void jbInit() throws Exception
  {
    System.out.println("Tworzenie komponentw interfejsu ...");
    image1 = new ImageIcon(helion.r3.JPictureView_Frame.class.getResource(
        "openFile.png"));
    image2 = new ImageIcon(helion.r3.JPictureView_Frame.class.getResource(
        "closeFile.png"));
    //closeImage = new ImageIcon("classes/helion/r4/close.gif");
    //closeImage = new ImageIcon(helion.r4.JPictureView_Frame.class.getResource("close.gif"));
    closeImage = new ImageIcon(this.getClass().getResource("close.gif"));
    contentPane = (JPanel)this.getContentPane();
    contentPane.setLayout(null);
    this.setSize(new Dimension(400, 300));
    this.setTitle("JPictureView");
    jButton1.setIcon(image1);
    jButton1.setText("Otwrz plik ...");
    jButton1.addActionListener(new JPictureView_Frame_jButton1_actionAdapter(this));
    jButton1.setToolTipText("Otwrz plik ...");
    jButton2.setIcon(image2);
    jButton2.setText("");
    jButton2.addActionListener(new JPictureView_Frame_jButton2_actionAdapter(this));
    jButton2.setToolTipText("Usu obraz");
    jToolBar.setDebugGraphicsOptions(0);
    jToolBar.setBounds(new Rectangle(0, 0, 400, 31));
    jButton3.setMinimumSize(new Dimension(57, 29));
    jButton3.setToolTipText("Zamknij aplikacj");
    jButton3.setIcon(closeImage);
    jButton3.setText("Zamknij");
    jButton3.addActionListener(new JPictureView_Frame_jButton3_actionAdapter(this));
    jButton4.setText("Negatyw");
    jButton4.addActionListener(new JPictureView_Frame_jButton4_actionAdapter(this));
    jButton5.setText("ASCII");
    jButton5.addActionListener(new JPictureView_Frame_jButton5_actionAdapter(this));
    jButton6.setToolTipText("");
    jButton6.setText("Szaro");
    jButton6.addActionListener(new JPictureView_Frame_jButton6_actionAdapter(this));
    jToolBar.add(jButton1);
    jToolBar.add(jButton2);
    jToolBar.add(jButton6, null);
    jToolBar.add(jButton4, null);
    jToolBar.add(jButton5, null);
    jToolBar.add(jButton3, null);
    contentPane.add(jToolBar, null);
    //dodany filtr do okna diaogowego
    jFileChooser1.setFileFilter(new javax.swing.filechooser.FileFilter()
                                    {
                                      public boolean accept(java.io.File f) {return f.isDirectory() || f.getPath().endsWith(".gif")|| f.getPath().endsWith(".jpeg")|| f.getPath().endsWith(".jpg")|| f.getPath().endsWith(".png");}
                                      public String getDescription() {return "Pliki graficzne (*.gif,*.jpg,*.png)";}
                                    });

  }

  //Overridden so we can exit when window is closed
  protected void processWindowEvent(WindowEvent e)
  {
    super.processWindowEvent(e);
    if (e.getID() == WindowEvent.WINDOW_CLOSING)
    {
      System.exit(0);
    }
  }

  Image obraz = null;
  JFileChooser jFileChooser1 = new JFileChooser();
  JButton jButton5 = new JButton();
  JButton jButton6 = new JButton();
  void jButton1_actionPerformed(ActionEvent e)
  {
    System.out.println("Wczytywanie obrazu ...");
    //JFileChooser jFileChooser1 = new JFileChooser();
    if (jFileChooser1.showOpenDialog(this) == JFileChooser.APPROVE_OPTION)
    {
      String nazwa_pliku = jFileChooser1.getSelectedFile().getAbsolutePath();

      //wczytywanie obrazka
      try
      {
        URL adres_pliku = new URL("file", null, nazwa_pliku);
        obraz = Toolkit.getDefaultToolkit().getImage(adres_pliku);
        //w aplecie: Image obrazek = this.getImage(new java.net.URL("file",null,nazwa_pliku));
        this.setTitle("JPictureView - " + nazwa_pliku);
        this.repaint();
        System.out.println("Prba wczytania obrazu z pliku " + nazwa_pliku);
      }
      catch (java.io.IOException exc)
      {
        System.err.println("Bd: " + exc.getMessage());
        JOptionPane.showMessageDialog(this, "Bd: " + exc.getMessage(),
                                      "Informacja o bdzie", 0);
      }
    }
  }

  public void paint(Graphics g)
  {
    //System.out.println("Odwieanie okna ...");
    super.paint(g); //to takze czyszci okno aplikacji
    if (obraz != null)
    {
      int szerokosc_brzegu_okna = (this.getWidth() - contentPane.getWidth())/2;
      int wysokosc_paska_tytulu = this.getHeight() - contentPane.getHeight() -
          szerokosc_brzegu_okna;
      g.drawImage(obraz, szerokosc_brzegu_okna,
                  wysokosc_paska_tytulu + jToolBar.getHeight(), this);
      jToolBar.repaint();
      //for (int i=0; i<this.getContentPane().getComponentCount(); i++) if (this.getContentPane().getComponent(i).isLightweight()) this.getContentPane().getComponent(i).repaint();
    }
  }

  /*
     //tylko do celw demonstracyjnych
     public void paint(Graphics g)
     {
    super.paint(g); //to takze czyszci okno aplikacji
    if (obraz!=null)
    {
      int wysokosc_paska_tytulu=this.getHeight()-contentPane.getHeight();
      g.drawImage(obraz,0,wysokosc_paska_tytulu,this);
      //jToolBar.repaint();
    }
     }
   */

  void jButton2_actionPerformed(ActionEvent e)
  {
    System.out.println("Kasowanie obrazu ...");
    obraz = null;
    this.setTitle("JPictureView");
    this.repaint();
  }

  void jButton3_actionPerformed(ActionEvent e)
  {
    System.out.println("Zamykanie aplikacji ...");
    //System.exit(0); //zamkniecie aplikacji
    this.dispose(); //zamkniecie okna
  }

  void jButton4_actionPerformed(ActionEvent e)
  {
    if (obraz == null)return;
    System.out.println("Tworzenie negatywu ...");

    //1)
    int szer = obraz.getWidth(this);
    int wys = obraz.getHeight(this);
    int piksele[] = new int[szer * wys];
    PixelGrabber pg = new PixelGrabber(obraz, 0, 0, szer, wys, piksele, 0, szer);
    try
    {
      pg.grabPixels();
    }
    catch (InterruptedException exc)
    {
      System.err.println("Bd: " + exc.getMessage());
      JOptionPane.showMessageDialog(this, "Bd: " + exc.getMessage(),
                                    "Informacja o bdzie",
                                    JOptionPane.ERROR_MESSAGE);
    }

    for (int i = 0; i < szer * wys; i++)
    {
      /*
             //Rozwiazanie 1
             int blue = (piksele[i] ) & 255;
             int green = (piksele[i] >> 8) & 255;
             int red = (piksele[i] >> 16) & 255;
             int alpha = (piksele[i] >> 24) & 255;

             red=255-red;
             green=255-green;
             blue=255-blue;

             //piksele[i] = (alpha << 24) | (red << 16) | (green << 8) | blue;
             piksele[i] = blue+(256)*green+(256*256)*red+(256*256*256)*alpha;
       */

      //Rozwiazanie 2
      /*
             int A=piksele[i] & 0xff000000;
             int RGB=piksele[i] & 0x00ffffff;

             RGB=~RGB;

             piksele[i]=A | (RGB & 0x00ffffff);
       */

      //Rozwiazanie 2 (skrocony zapis)
      piksele[i] = (piksele[i] & 0xff000000) | ~ (piksele[i] & 0x00ffffff);
    }

    obraz = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(szer,
        wys, piksele, 0, szer));
    this.repaint();
  }

  //KONWERSJA ASCII
  void jButton5_actionPerformed(ActionEvent e)
  {
    if (obraz == null)return;
    System.out.println("Konwersja ASCII ...");

    //1)
    int szer = obraz.getWidth(this);
    int wys = obraz.getHeight(this);
    int piksele[] = new int[szer * wys];
    PixelGrabber pg = new PixelGrabber(obraz, 0, 0, szer, wys, piksele, 0, szer);
    try
    {
      pg.grabPixels();
    }
    catch (InterruptedException exc)
    {
      System.err.println("Bd: " + exc.getMessage());
      JOptionPane.showMessageDialog(this, "Bd: " + exc.getMessage(),
                                    "Informacja o bdzie",
                                    JOptionPane.ERROR_MESSAGE);
    }

    //$@B%8&WM#*oahkbdpqwmZO0QLCJUYXzcvunxrjft/\|()1{}[]?-_+~<>i!lI;:,"^`'.
    //0-70 (71 elementow)
    String paletaASCII =
        "$@B%8&WM#*oahkbdpqwmZO0QLCJUYXzcvunxrjft/\\|()1{}[]?-_+~<>i!lI;:,\"^//`'. ";
    int iloscOdcieniASCII = paletaASCII.length();
    System.out.println("Skala szaroci ASCII: " + paletaASCII);
    System.out.println("Ilosc odcieni: " + iloscOdcieniASCII);
    String imgASCII = "";
    for (int i = 0; i < szer * wys; i++)
    {
      int blue = (piksele[i]) & 255;
      int green = (piksele[i] >> 8) & 255;
      int red = (piksele[i] >> 16) & 255;

      int jasnosc = (int) Math.round( ( (iloscOdcieniASCII - 1) / 255.0) *
                                     (blue + green + red) / 3.0); //0-70 (71 elementow)

      char pikselASCII = paletaASCII.charAt(jasnosc);
      System.out.print(pikselASCII);
      imgASCII += pikselASCII;
      if ( ( (i + 1) % szer) == 0)
      {
        System.out.println();
        imgASCII += '\n';
      }
    }

    if (JOptionPane.showConfirmDialog(this, "Czy zapisa ASCII do pliku?",
                                      "Zapis do pliku",
                                      JOptionPane.YES_NO_OPTION,
                                      JOptionPane.QUESTION_MESSAGE) == JOptionPane.YES_OPTION)
    {
      jFileChooser1.setSelectedFile(new java.io.File(jFileChooser1.getSelectedFile().getAbsolutePath() + ".txt"));
      if (jFileChooser1.showSaveDialog(this) == JFileChooser.APPROVE_OPTION)
      {
        try
        {
          String nazwa_pliku = jFileChooser1.getSelectedFile().getAbsolutePath();
          zapiszDoPlikuTekstowego(nazwa_pliku, imgASCII);
          System.out.println("ASCII zapisany do pliku " + nazwa_pliku);
        }
        catch (java.io.IOException exc)
        {
          System.err.println("Bd: " + exc.getMessage());
          JOptionPane.showMessageDialog(this, "Bd: " + exc.getMessage(),
                                        "Informacja o bdzie",
                                        JOptionPane.ERROR_MESSAGE);
        }
      }
    }
  }

  //skopiowane z Notatnik_Frame
  public static void zapiszDoPlikuTekstowego(String nazwa_pliku, String tekst) throws
      java.io.IOException
  {
    try
    {
      java.io.FileWriter plik_wy = new java.io.FileWriter(nazwa_pliku);
      plik_wy.write(tekst);
      plik_wy.close();
    }
    catch (java.io.IOException exc)
    {
      throw exc;
    }
  }

  //KONWERSJA DO SKALI SZAROSCI
  void jButton6_actionPerformed(ActionEvent e)
  {
    if (obraz == null)return;
    System.out.println("Konwersja do skali szaroci ...");

    //1)
    int szer = obraz.getWidth(this);
    int wys = obraz.getHeight(this);
    int piksele[] = new int[szer * wys];
    PixelGrabber pg = new PixelGrabber(obraz, 0, 0, szer, wys, piksele, 0, szer);
    try
    {
      pg.grabPixels();
    }
    catch (InterruptedException exc)
    {
      System.err.println("Bd: " + exc.getMessage());
      JOptionPane.showMessageDialog(this, "Bd: " + exc.getMessage(),
                                    "Informacja o bdzie",
                                    JOptionPane.ERROR_MESSAGE);
    }

    for (int i = 0; i < szer * wys; i++)
    {
      int blue = (piksele[i]) & 255;
      int green = (piksele[i] >> 8) & 255;
      int red = (piksele[i] >> 16) & 255;
      int alpha = (piksele[i] >> 24) & 255;

      int jasnosc = (int) Math.round((blue + green + red) / 3.0);
      blue=green=red=jasnosc;

      piksele[i] = blue+(256)*green+(256*256)*red+(256*256*256)*alpha;
    }

    obraz = Toolkit.getDefaultToolkit().createImage(new MemoryImageSource(szer,
        wys, piksele, 0, szer));
    this.repaint();
  }

  class JPictureView_Frame_jButton1_actionAdapter
      implements java.awt.event.ActionListener
  {
    JPictureView_Frame adaptee;

    JPictureView_Frame_jButton1_actionAdapter(JPictureView_Frame adaptee)
    {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e)
    {
      adaptee.jButton1_actionPerformed(e);
    }
  }

  class JPictureView_Frame_jButton2_actionAdapter
      implements java.awt.event.ActionListener
  {
    JPictureView_Frame adaptee;

    JPictureView_Frame_jButton2_actionAdapter(JPictureView_Frame adaptee)
    {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e)
    {
      adaptee.jButton2_actionPerformed(e);
    }
  }

  class JPictureView_Frame_jButton3_actionAdapter
      implements java.awt.event.ActionListener
  {
    JPictureView_Frame adaptee;

    JPictureView_Frame_jButton3_actionAdapter(JPictureView_Frame adaptee)
    {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e)
    {
      adaptee.jButton3_actionPerformed(e);
    }
  }

  class JPictureView_Frame_jButton4_actionAdapter
      implements java.awt.event.ActionListener
  {
    JPictureView_Frame adaptee;

    JPictureView_Frame_jButton4_actionAdapter(JPictureView_Frame adaptee)
    {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e)
    {
      adaptee.jButton4_actionPerformed(e);
    }
  }

  class JPictureView_Frame_jButton5_actionAdapter
      implements java.awt.event.ActionListener
  {
    JPictureView_Frame adaptee;

    JPictureView_Frame_jButton5_actionAdapter(JPictureView_Frame adaptee)
    {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e)
    {
      adaptee.jButton5_actionPerformed(e);
    }
  }

  class JPictureView_Frame_jButton6_actionAdapter
      implements java.awt.event.ActionListener
  {
    JPictureView_Frame adaptee;

    JPictureView_Frame_jButton6_actionAdapter(JPictureView_Frame adaptee)
    {
      this.adaptee = adaptee;
    }

    public void actionPerformed(ActionEvent e)
    {
      adaptee.jButton6_actionPerformed(e);
    }
  }
}

class JPictureView_Frame_jButton2_actionAdapter implements java.awt.event.ActionListener {
  JPictureView_Frame adaptee;

  JPictureView_Frame_jButton2_actionAdapter(JPictureView_Frame adaptee) {
    this.adaptee = adaptee;
  }
  public void actionPerformed(ActionEvent e) {
    adaptee.jButton2_actionPerformed(e);
  }
}
