package helion.xc;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class Gradient_BufferedApplet extends BufferedApplet {
  private boolean isStandalone = false;
  Scrollbar scrollbar1 = new Scrollbar();
  Checkbox checkbox1 = new Checkbox();
  //Get a parameter value
  public String getParameter(String key, String def) {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public Gradient_BufferedApplet() {
  }
  //Initialize the applet
  public void init() {
    try {
      jbInit();
    }
    catch(Exception e) {
      e.printStackTrace();
    }
  }
  //Component initialization
  private void jbInit() throws Exception {
    this.setLayout(null);
    scrollbar1.setBounds(new Rectangle(7, 6, 20, 282));
    scrollbar1.addAdjustmentListener(new Gradient_BufferedApplet_scrollbar1_adjustmentAdapter(this));
    checkbox1.setLabel("Buforowanie");
    checkbox1.setState(true);
    checkbox1.setBounds(new Rectangle(41, 266, 94, 21));
    checkbox1.addItemListener(new Gradient_BufferedApplet_checkbox1_itemAdapter(this));
    this.add(scrollbar1, null);
    this.add(checkbox1, null);
  }
  //Start the applet
  public void start() {
    repaint();
  }
  //Stop the applet
  public void stop() {
    repaint();
  }
  //Destroy the applet
  public void destroy() {
  }
  //Get Applet information
  public String getAppletInfo() {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo() {
    return null;
  }


  public void paint(Graphics g)
  {
  //float barwa=(float)Math.random();
  float barwa=(float)(scrollbar1.getValue()-scrollbar1.getMinimum())/(scrollbar1.getMaximum()-scrollbar1.getMinimum()-scrollbar1.getBlockIncrement());
  int wysokosc=this.getBounds().height;
  for(int indeks=0;indeks<wysokosc;indeks++)
      {
      float jasnosc=indeks/(float)(wysokosc-1);
      Color kolor=Color.getHSBColor(barwa,1,jasnosc);
      g.setColor(kolor);
      //g.setColor(Color.getHSBColor(barwa,1,indeks/(float)(wysokosc-1)));
      g.drawLine(0,indeks,this.getBounds().width,indeks);
      }
  }

  void scrollbar1_adjustmentValueChanged(AdjustmentEvent e) {
    //showStatus(""+scrollbar1.getValue());
    repaint();
  }

  void checkbox1_itemStateChanged(ItemEvent e) {
    podwojne_buforowanie=checkbox1.getState();
    this.update(this.getGraphics());
  }


  /*public void update(Graphics g)
  {
    if (this.isShowing()) {
      Rectangle dim=this.getBounds();
      int w=dim.width, h=dim.height;
      g.clearRect(0, 0, w, h);
      paint(g);
    }
  }*/
}

class Gradient_BufferedApplet_scrollbar1_adjustmentAdapter implements java.awt.event.AdjustmentListener {
  Gradient_BufferedApplet adaptee;

  Gradient_BufferedApplet_scrollbar1_adjustmentAdapter(Gradient_BufferedApplet adaptee) {
    this.adaptee = adaptee;
  }
  public void adjustmentValueChanged(AdjustmentEvent e) {
    adaptee.scrollbar1_adjustmentValueChanged(e);
  }
}

class Gradient_BufferedApplet_checkbox1_itemAdapter implements java.awt.event.ItemListener {
  Gradient_BufferedApplet adaptee;

  Gradient_BufferedApplet_checkbox1_itemAdapter(Gradient_BufferedApplet adaptee) {
    this.adaptee = adaptee;
  }
  public void itemStateChanged(ItemEvent e) {
    adaptee.checkbox1_itemStateChanged(e);
  }
}
