package helion.xc;

import java.awt.Graphics;
import java.awt.Point;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class Strzalka {

  private int fxpocz,fypocz;
  private int fxkonc=0,fykonc=0;
  private int fdlg,fkat; //kat w stopniach
  private double fkat_rad; //kat w radianach
  private boolean fgrot;

  //stale okreslajace wyglad grota
  private int fgrot_rozchylenie=20; //w stopniach
  private boolean fgrot_proporcjonalny=false;
  private float fgrot_skrocenie=5;
  private int fgrot_dlugosc=15;


  public void setPunktZaczepienia(int xpocz,int ypocz)
    {
    fxpocz=xpocz;
    fypocz=ypocz;
    obliczPozycjeKonca();
    };

  public void setPunktZaczepienia(Point pocz)
    {
    fxpocz=pocz.x;
    fypocz=pocz.y;
    obliczPozycjeKonca();
    };


  public void setDlugosc(int dlg)
    {
    fdlg=dlg;
    obliczPozycjeKonca();
    };

  public void setKat(int kat)
    {
    fkat=kat-90;
    fkat_rad=toRadians(fkat); //kat w radianach od pionu
    obliczPozycjeKonca();
    };

  public void obracaj(int zmiana_kata)
    {
    setKat(fkat+zmiana_kata);
    obliczPozycjeKonca();
    }

  public void setGrot(boolean grot)
    {
    fgrot=grot;
    }

  public void setGrotWlasnosci(int rozchylenie,boolean proporcjonalny,float skrocenie,int dlugosc)
    {
    fgrot_rozchylenie=rozchylenie;
    fgrot_proporcjonalny=proporcjonalny;
    fgrot_skrocenie=skrocenie;
    fgrot_dlugosc=dlugosc;
    }

  public static double toRadians(int angdeg)
    {
    //return 2*Math.PI*(angdeg)/360.0;
    return angdeg / 180.0 * Math.PI;
    }

  private void obliczPozycjeKonca()
    {
    fxkonc=fxpocz+(int)(fdlg*Math.cos(fkat_rad));
    fykonc=fypocz+(int)(fdlg*Math.sin(fkat_rad));
    }

  public int getXKonc()
    {
    return fxkonc;
    }

  public int getYKonc()
    {
    return fykonc;
    }

  public Point getPunktKonca()
    {
    return new Point(fxkonc,fykonc);
    }

  //konstruktor z parametrami (nie ma konstruktora domyslnego)
  public Strzalka(int xpocz,int ypocz,int dlg,int kat, boolean agrot)
    {
    setPunktZaczepienia(xpocz,ypocz);
    setDlugosc(dlg);
    setKat(kat);
    setGrot(agrot);
    }

  public void rysuj(Graphics g)
    {
    //glowna linia
    g.drawLine(fxpocz,fypocz,fxkonc,fykonc);

    if (fgrot) //grot
      {
      //prawa linia
      int grotdlg=fgrot_proporcjonalny?Math.round(fdlg/fgrot_skrocenie):fgrot_dlugosc;
      double grot_roz_rad=toRadians(fgrot_rozchylenie);
      double grotkat_rad=fkat_rad+Math.PI+grot_roz_rad;
      int xgrotkonc=fxkonc+(int)(grotdlg*Math.cos(grotkat_rad));
      int ygrotkonc=fykonc+(int)(grotdlg*Math.sin(grotkat_rad));
      g.drawLine(fxkonc,fykonc,xgrotkonc,ygrotkonc);
      //lewa linia
      grotkat_rad=fkat_rad+Math.PI-grot_roz_rad;
      xgrotkonc=fxkonc+(int)(grotdlg*Math.cos(grotkat_rad));
      ygrotkonc=fykonc+(int)(grotdlg*Math.sin(grotkat_rad));
      g.drawLine(fxkonc,fykonc,xgrotkonc,ygrotkonc);
      }
   }


}
