package helion.xc;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class StrzalkaDemo extends BufferedApplet
{
  boolean isStandalone = false;
  Scrollbar scrollbar1 = new Scrollbar();
  Scrollbar scrollbar2 = new Scrollbar();
  Label label1 = new Label();
  Label label2 = new Label();
  Checkbox checkbox1 = new Checkbox();
  Checkbox checkbox2 = new Checkbox();

  //Dodane recznie
  Strzalka s=null;

  //Get a parameter value
  public String getParameter(String key, String def)
  {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }

  //Construct the applet
  public StrzalkaDemo()
  {
  }
  //Initialize the applet
  public void init()
  {
    try
    {
      jbInit();
      jmInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }
  //Component initialization
  private void jbInit() throws Exception
  {
    this.setLayout(null);
    scrollbar1.setBlockIncrement(10);
    scrollbar1.setMaximum(110);
    //scrollbar1.setPageIncrement(1);
    scrollbar1.setValue(50);
    scrollbar1.setBounds(new Rectangle(330, 38, 21, 250));
    scrollbar1.addAdjustmentListener(new java.awt.event.AdjustmentListener()
    {
      public void adjustmentValueChanged(AdjustmentEvent e)
      {
        scrollbar1_adjustmentValueChanged(e);
      }
    });
    scrollbar2.setMaximum(370);
    scrollbar2.setBounds(new Rectangle(360, 38, 24, 250));
    scrollbar2.addAdjustmentListener(new java.awt.event.AdjustmentListener()
    {
      public void adjustmentValueChanged(AdjustmentEvent e)
      {
        scrollbar2_adjustmentValueChanged(e);
      }
    });
    label1.setBackground(Color.white);
    label1.setFont(new java.awt.Font("Dialog", 0, 15));
    label1.setText("dlg");
    label1.setBounds(new Rectangle(330, 8, 21, 23));
    label2.setBackground(Color.white);
    label2.setFont(new java.awt.Font("Dialog", 0, 15));
    label2.setText("kat");
    label2.setBounds(new Rectangle(360, 9, 21, 20));
    checkbox1.setBackground(Color.white);
    checkbox1.setFont(new java.awt.Font("Dialog", 0, 15));
    checkbox1.setLabel("grot");
    checkbox1.setState(true);
    checkbox1.setBounds(new Rectangle(16, 260, 53, 20));
    checkbox1.addItemListener(new java.awt.event.ItemListener()
    {
      public void itemStateChanged(ItemEvent e)
      {
        checkbox1_itemStateChanged(e);
      }
    });
    checkbox2.setLabel("proporcjonalny");
    checkbox2.setState(true);
    checkbox2.setBounds(new Rectangle(70, 263, 108, 16));
    checkbox2.addItemListener(new java.awt.event.ItemListener() {
      public void itemStateChanged(ItemEvent e) {
        checkbox2_itemStateChanged(e);
      }
    });
    this.add(scrollbar1, null);
    this.add(scrollbar2, null);
    this.add(label1, null);
    this.add(label2, null);
    this.add(checkbox1, null);
    this.add(checkbox2, null);
  }

  private void jmInit()
    {
    this.setBackground(Color.white);
    }

  //Get Applet information
  public String getAppletInfo()
  {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo()
  {
    return null;
  }

  //RECZNIE NAPISANE
  public void paint(Graphics g)
    {
    super.paint(g);

    //opisy
    g.drawString("dlg: "+scrollbar1.getValue(),10,15);
    g.drawString("kat: "+scrollbar2.getValue(),10,30);

    //strzalka
    if (s==null) //pierwszy raz
      {
      s = new Strzalka(this.getBounds().width/2, this.getBounds().height/2, scrollbar1.getValue(),scrollbar2.getValue(), checkbox1.getState());
      s.setGrotWlasnosci(20,checkbox2.getState(),5,15);
      }

    s.rysuj(g);
    }

  void scrollbar1_adjustmentValueChanged(AdjustmentEvent e)
  {
  s.setDlugosc(scrollbar1.getValue());
  repaint();
  }

  void scrollbar2_adjustmentValueChanged(AdjustmentEvent e)
  {
  s.setKat(scrollbar2.getValue());
  repaint();
  }

  void checkbox1_itemStateChanged(ItemEvent e)
  {
  s.setGrot(checkbox1.getState());
  repaint();
  }

  void checkbox2_itemStateChanged(ItemEvent e)
  {
  s.setGrotWlasnosci(20,checkbox2.getState(),5,15);
  repaint();
  }
}
