package helion.xc;

import java.awt.*;
import java.awt.event.*;
import java.applet.*;

//recznie dodane
import java.util.*;
import javax.swing.Timer;
import java.awt.Graphics2D; //od JDK 1.2

/**
 * <p>Title: JBuilder X. Efektywne programowanie w Javie</p>
 * <p>Description: rda wicze z ksiki "JBuilder X. Efektywne programowanie w Javie"</p>
 * <p>Copyright: Copyright (c) 2004</p>
 * <p>WWW: <A HREF="http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/">http://www.phys.uni.torun.pl/~jacek/dydaktyka/helion/jbuilderx/</A></p>
 * @author Jacek Matulewski
 * @version 1.0
 */

public class Zegar extends BufferedApplet //Buforowanie
{
  boolean isStandalone = false;

  //Taktometr
  private Timer timer=new Timer(1000,
                              new ActionListener()
                                {
                                public void actionPerformed(ActionEvent evt)
                                   {
                                   repaint();
                                   }
                               });

  //Get a parameter value
  public String getParameter(String key, String def)
  {
    return isStandalone ? System.getProperty(key, def) :
      (getParameter(key) != null ? getParameter(key) : def);
  }


  //Initialize the applet
  public void init()
  {
    try
    {
      jbInit();
    }
    catch(Exception e)
    {
      e.printStackTrace();
    }
  }
  //Component initialization
  private void jbInit() throws Exception
  {
  }
  //Get Applet information
  public String getAppletInfo()
  {
    return "Applet Information";
  }
  //Get parameter info
  public String[][] getParameterInfo()
  {
    return null;
  }


public void start()
  {
  this.setBackground(Color.white);
  timer.start();
  }

public void stop()
  {
  timer.stop();
  }

public void paint(Graphics g)
  {
  int rozmiar=Math.min(this.getBounds().width,this.getBounds().height);
  int szer=rozmiar/30;
  int wysgodz=2*szer;
  Color kolorBrzegu=new Color(0,150,0);
  Color kolorTla=new Color(192,235,192);


  //tarcza
  g.setColor(kolorBrzegu);
  g.fillOval(0,0,rozmiar,rozmiar);
  g.setColor(kolorTla);
  g.fillOval(szer,szer,rozmiar-2*szer,rozmiar-2*szer);

  //godziny na tarczy
  g.setColor(kolorBrzegu);
  g.fillRect(rozmiar/2-szer/2,2*szer,szer,wysgodz); //12
  g.fillRect(rozmiar/2-szer/2,rozmiar-4*szer,szer,wysgodz); //6
  g.fillRect(2*szer,rozmiar/2-szer/2,wysgodz,szer); //9
  g.fillRect(rozmiar-4*szer,rozmiar/2-szer/2,wysgodz,szer); //3

  GregorianCalendar cal = new GregorianCalendar(); //wymaga java.util.*

  int godzina=cal.get(cal.HOUR); //biala
  int minuta=cal.get(cal.MINUTE); //zielona
  int sekunda=cal.get(cal.SECOND); //zolta
  int milisekunda=cal.get(cal.MILLISECOND);

  showStatus(""+godzina+":"+minuta+":"+sekunda);

  int godzina_kat=(int)(360.0*(godzina+minuta/60.0)/12.0); //zeby nie bylo skokow
  int minuta_kat=(int)(360*minuta/60); //tu skok wskazowki
  int sekunda_kat=(int)(360*(sekunda+milisekunda/1000.0)/60); //zeby plynnie

  Strzalka wsk_godzina=new Strzalka(rozmiar/2,rozmiar/2,rozmiar/4,godzina_kat,false);
  Strzalka wsk_minuta =new Strzalka(rozmiar/2,rozmiar/2,rozmiar/3,minuta_kat,false);
  Strzalka wsk_sekunda=new Strzalka(rozmiar/2,rozmiar/2,rozmiar/3,sekunda_kat,false);

  Graphics2D g2=(Graphics2D) g; //Graphics2D jest klasa abstrakcyjna, nie tworzymy obiektu tej klasy, tylko rzutujemy na ta klase
  int grubosc=(int)(rozmiar/60.0);
  int min_grubosc=4;
  g2.setStroke(new BasicStroke(grubosc>min_grubosc?grubosc:min_grubosc,
                               BasicStroke.CAP_ROUND,
                               BasicStroke.JOIN_ROUND));

  g.setColor(Color.white);wsk_godzina.rysuj(g);
  g.setColor(Color.green);wsk_minuta.rysuj(g);
  g.setColor(Color.yellow);wsk_sekunda.rysuj(g);
  }
}
