﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Watki
{
    class Program
    {
        static Random r = new Random();

        static void Main(string[] args)
        {
            //uruchamianieObliczenPi();

            Thread t = new Thread(uruchamianieObliczenPi);
            t.Priority = ThreadPriority.Highest;
            //t.IsBackground = true;
            t.Start();
            
            //Thread.Sleep(500);

            //t.Abort();
            //Console.WriteLine("Czy ten napis pojawi się przed otrzymaniem wyniku?");

            //t.Suspend();
            //Console.WriteLine("Naciśnij Enter, aby kontynuować działanie wątku...");
            //Console.ReadLine();
            //t.Resume();
        }

        static double obliczPi(long ilośćPrób)
        {
            double x, y;
            long ilośćTrafień = 0;
            for (long i = 0; i < ilośćPrób; ++i)
            {
                x = r.NextDouble();
                y = r.NextDouble();
                if (x * x + y * y < 1) ++ilośćTrafień;
                //Console.WriteLine("x={0}, y={1}", x, y);
            }
            return 4.0 * ilośćTrafień / ilośćPrób;
        }

        static void uruchamianieObliczenPi()
        {
            try
            {
                int czasPoczatkowy = Environment.TickCount;
                Console.WriteLine("Uruchamianie obliczeń, watek nr {0}...", Thread.CurrentThread.ManagedThreadId);

                long ilośćPrób = 10000000L;
                double pi = obliczPi(ilośćPrób: ilośćPrób);
                Console.WriteLine("Pi={0}, błąd={1}, wątek nr {2}", pi, Math.Abs(Math.PI - pi), Thread.CurrentThread.ManagedThreadId);

                int czasKoncowy = Environment.TickCount;
                int roznica = czasKoncowy - czasPoczatkowy;
                Console.WriteLine("Czas obliczeń: " + (roznica).ToString());
            }
            catch (ThreadAbortException exc)
            {
                Console.WriteLine("Działanie wątku zostało przerwane (" + exc.Message + ")");
            }
            catch (Exception exc)
            {
                Console.WriteLine("Wyjątek (" + exc.Message + ")");
            }
        }
    }
}
