﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace Watki
{
    class Program
    {
        static Random r = new Random();
        const int ileWatkow = 10;
        static double pi = 0;

        static void Main(string[] args)
        {
            int czasPoczatkowy = Environment.TickCount;

            //tworzenie watkow
            Thread[] tt = new Thread[ileWatkow];
            for (int i = 0; i < ileWatkow; ++i)
            {
                tt[i] = new Thread(uruchamianieObliczenPi);
                //tt[i].Priority = ThreadPriority.Highest;
                tt[i].Start();
            }

            //czekanie na zakonczenie watkow
            foreach (Thread t in tt)
            {
                t.Join();
                Console.WriteLine("Zakończył działanie wątek nr {0}", t.ManagedThreadId);
            }
            pi /= ileWatkow;
            Console.WriteLine("Wszystkie wątki zakończyły działanie.\nUśrednione Pi={0}, błąd={1}", pi, Math.Abs(Math.PI - pi));

            int czasKoncowy = Environment.TickCount;
            int roznica = czasKoncowy - czasPoczatkowy;
            Console.WriteLine("Czas obliczeń: " + (roznica).ToString());
        }

        static double obliczPi(long ilośćPrób)
        {
            Random r = new Random(Program.r.Next() & DateTime.Now.Millisecond);
            double x, y;
            long ilośćTrafień = 0;
            for (long i = 0; i < ilośćPrób; ++i)
            {
                /*
                //sekcja krytyczna
                if (i == ilośćPrób / 2)
                {
                    lock (Program.r)
                    {
                        Console.WriteLine("Synchronizacja: wątek nr {0} osiągnął półmetek",
                                          Thread.CurrentThread.ManagedThreadId);
                    }
                }
                */

                x = r.NextDouble();
                y = r.NextDouble();
                if (x * x + y * y < 1) ++ilośćTrafień;
                //Console.WriteLine("x={0}, y={1}", x, y);
            }
            return 4.0 * ilośćTrafień / ilośćPrób;
        }

        static void uruchamianieObliczenPi()
        {
            try
            {
                //int czasPoczatkowy = Environment.TickCount;
                Console.WriteLine("Uruchamianie obliczeń, watek nr {0}...", Thread.CurrentThread.ManagedThreadId);

                long ilośćPrób = 1000000000L / ileWatkow;
                double pi = obliczPi(ilośćPrób: ilośćPrób);
                lock(r) Program.pi += pi;
                Console.WriteLine("Pi={0}, błąd={1}, wątek nr {2}", pi, Math.Abs(Math.PI - pi), Thread.CurrentThread.ManagedThreadId);

                //int czasKoncowy = Environment.TickCount;
                //int roznica = czasKoncowy - czasPoczatkowy;
                //Console.WriteLine("Czas obliczeń: " + (roznica).ToString());
            }
            catch (ThreadAbortException exc)
            {
                Console.WriteLine("Działanie wątku zostało przerwane (" + exc.Message + ")");
            }
            catch (Exception exc)
            {
                Console.WriteLine("Wyjątek (" + exc.Message + ")");
            }
        }
    }
}
