﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace LeniwaInicjacja
{
    class Program
    {
        //static Lazy<int> li = new Lazy<int>(() => Thread.CurrentThread.ManagedThreadId,false);
        //źle: [ThreadStatic] static Lazy<int> li = new Lazy<int>(() => Thread.CurrentThread.ManagedThreadId);
        static ThreadLocal<int> li = new ThreadLocal<int>(() => Thread.CurrentThread.ManagedThreadId);
        
        static void Main(string[] args)
        {
            /*
            Lazy<int> li = new Lazy<int>(() => 1); //deklaracja zmiennej i wskazanie funkcji
            Console.WriteLine("Czy utworzona?: " + li.IsValueCreated.ToString()); //jeszcze niezainicjowana
            Console.WriteLine("Odwołanie do zmiennej, li=" + li.Value); //leniwa inicjacja
            Console.WriteLine("Czy utworzona?: " + li.IsValueCreated.ToString()); //już zainicjowana
            */

            WaitCallback metodaWatku = 
                (object parametr) =>
                {                    
                    lock (li)
                    {
                        Console.WriteLine("Wątek: " + Thread.CurrentThread.ManagedThreadId.ToString() + ", Czy utworzona: " + li.IsValueCreated.ToString()); //jeszcze niezainicjowana                    
                        Console.WriteLine("Wątek: " + Thread.CurrentThread.ManagedThreadId.ToString() + ", li= " + li.Value.ToString()); //leniwa inicjacja
                        Console.WriteLine("Wątek: " + Thread.CurrentThread.ManagedThreadId.ToString() + ", Czy utworzona: " + li.IsValueCreated.ToString()); //już zainicjowana
                    }
                };
            for (int i = 0; i < 4; ++i)
                ThreadPool.QueueUserWorkItem(metodaWatku, i);

            Console.ReadLine(); //wątek główny czeka na dodatkowe wątki
        }
    }
}
