﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace ThreadStatic
{
    class Program
    {
        [ThreadStatic]        
        static int licznik = 0;

        static void Main(string[] args)
        {
            WaitCallback metodaWatku = 
                (object parametr) =>
                {
                    //licznik++;
                    Interlocked.Increment(ref licznik);
                    Console.WriteLine("Wątek: " + Thread.CurrentThread.ManagedThreadId + ", licznik=" + licznik.ToString());
                };
            for (int i = 0; i < 4; ++i)
                ThreadPool.QueueUserWorkItem(metodaWatku, i);
            
            Console.ReadLine(); //wątek główny czeka na dodatkowe wątki

            Console.WriteLine("Koniec, licznik=" + licznik.ToString());
        }
    }
}
