﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace MutexDemo
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Aplikacja została uruchomiona");

            //kontrola ilości instancji aplikacji
            Mutex m = new Mutex(false, "BardzoUnikalnaNazwaMuteksu");
            Console.WriteLine("Muteks został utworzony");
            Console.WriteLine();            

            bool koniec = false;

            while (true)
            {                
                m.WaitOne(); //czeka kiedy bedzie mozna wejsc do sekcji krytycznej
                Console.Write('[');
                if (Console.KeyAvailable)
                {
                    switch(Console.ReadKey(true).Key)
                    {
                        case ConsoleKey.Enter:
                            Console.WriteLine();                            
                            Console.WriteLine("\n\nWątek został wstrzymany w sekcji krytycznej.\nNaciśnij Enter aby zwolnić muteks...");
                            Console.ReadLine();                            
                            break;
                        case ConsoleKey.Escape:                            
                            koniec = true;
                            break;
                    }
                }
                m.ReleaseMutex(); //zwalnia muteks (opuszcza sekcję krytyczną)
                Console.Write("]");
                if (koniec)
                {
                    Console.WriteLine("\n\nKoniec.");
                    return;
                }
                Thread.Sleep(1000);
                Console.Write(" ");
            }
        }
    }
}
