﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

using System.Threading;

namespace SemaphoreDemo
{
    class Program
    {
        static void Main(string[] args)
        {
            Console.WriteLine("Aplikacja została uruchomiona");
            int iloscWatkowWSekcjiKrytycznej = System.Environment.ProcessorCount;
            Console.WriteLine("Ile wątków może być jednocześnie w sekcji krytycznej: " + iloscWatkowWSekcjiKrytycznej.ToString());

            //kontrola ilości instancji aplikacji
            Semaphore s = new Semaphore(iloscWatkowWSekcjiKrytycznej, iloscWatkowWSekcjiKrytycznej, "BardzoUnikalnaNazwaSemafora");
            Console.WriteLine("Semafor został utworzony");
            Console.WriteLine();

            bool koniec = false;

            while (true)
            {
                s.WaitOne(); //czeka kiedy bedzie mozna wejsc do sekcji krytycznej
                Console.Write('[');
                if (Console.KeyAvailable)
                {
                    switch (Console.ReadKey(true).Key)
                    {
                        case ConsoleKey.Enter:
                            Console.WriteLine();
                            Console.WriteLine("\n\nWątek został wstrzymany w sekcji krytycznej.\nNaciśnij Enter aby zwolnić muteks...");
                            Console.ReadLine();
                            break;
                        case ConsoleKey.Escape:
                            koniec = true;
                            break;
                    }
                }
                int ilePozostaloMiejscNaWatkiWSekcjiKrytycznej = s.Release(); //zwalnia semafor (opuszcza sekcję krytyczną)
                Console.Write(ilePozostaloMiejscNaWatkiWSekcjiKrytycznej.ToString() + "]");
                if (koniec)
                {
                    Console.WriteLine("\n\nKoniec.");
                    return;
                }
                Thread.Sleep(1000);
                Console.Write(" ");
            }
        }
    }
}
