#include "fsdl.h"
#include <cstdio>
fsdl m(30, 640, 480, 32, "MAPEDIT");


// map detail
#define WIDTH  100
#define HEIGHT 100

const char* map_file       = "maps/3.map"; // podloze
const char* map_item_file  = "maps/3.det"; // przeszkody - itp
const char* map_point_file = "maps/3.ptn"; // check pointy

char mapa[HEIGHT][WIDTH]      = {0};
char mapa_item[HEIGHT][WIDTH]  = {0};
char mapa_point[HEIGHT][WIDTH] = {0};

//tekstury dla mapy
tekstura ground (m.okno(), "gfx/teren.bmp");
int max_frame_int = 13;
int current_frame = 1;


//itemy
//tekstura itemy (m.okno(), "gfx/przedmioty.bmp", 0xff00ff);

// point
tekstura point (m.okno(), "gfx/bramka.bmp", 0xff00ff);
int point_num = 0;
int point_rot = 0;


tekstura nums (m.okno(), "gfx/nums.bmp");

// przesuniecie mapy
int map_offset_x = 0;
int map_offset_y = 0;


// myszka
int mx;
int my;



void pre(){
  // ramka w teksturze
  ground.ustaw_ramke(40, 40);
  point.ustaw_ramke(40, 40);
  nums.ustaw_ramke(9,9);

  // otwieranie mapy
  FILE* file = fopen(map_file, "rb");
  if(file){
    fread(mapa, 1, sizeof(mapa), file);
    fclose(file);
    printf("mapa wczytana!\n");
  }else{
    file = fopen(map_file, "wb");
    fwrite(mapa, 1, sizeof(mapa), file);
    fclose(file);
    printf("mapa utworzona!\n");
  }

  // otwieranie tablicy itemow
  file = fopen(map_item_file, "rb");
  if(file){
    fread(mapa_item, 1, sizeof(mapa_item), file);
    fclose(file);
    printf("itemy wczytane!\n");
  }else{
    file = fopen(map_item_file, "wb");
    fwrite(mapa_item, 1, sizeof(mapa_item), file);
    fclose(file);
    printf("itemy utworzone!\n");
  }

  // otwieranie tablicy itemow
  file = fopen(map_point_file, "rb");
  if(file){
    fread(mapa_point, 1, sizeof(mapa_point), file);
    fclose(file);
    printf("check pointy wczytane!\n");
  }else{
    file = fopen(map_point_file, "wb");
    fwrite(mapa_point, 1, sizeof(mapa_point), file);
    fclose(file);
    printf("check poitny utworzone!\n");
  }


}

void po(){
 // narazie nic nie alokuje dynamicznie
}

void logika(){

  mx = ((int)m.myszka.x - map_offset_x) / 40;
  my = ((int)m.myszka.y - map_offset_y) / 40;


  // przesuwanie mapa
  if(m.klawiatura['w']) map_offset_y+=15;
  if(m.klawiatura['s']) map_offset_y-=15;
  if(m.klawiatura['a']) map_offset_x+=15;
  if(m.klawiatura['d']) map_offset_x-=15;



  // dotyczace terenu
  if(!m.klawiatura[K_SPACE]){

    // wybor tekstury
    if(m.klawiatura[K_UP]){
      m.klawiatura[K_UP] = false;
      current_frame++;
      if(current_frame > max_frame_int) current_frame = 0;
    }
    if(m.klawiatura[K_DOWN]){
      m.klawiatura[K_DOWN] = false;
      current_frame--;
      if(current_frame < 0) current_frame=max_frame_int;
    }
  
    // wypalenie terenu na mapie
    if(m.myszka.lewy){
      //m.myszka.lewy = false;
      mapa[my][mx] = (char)current_frame;
      printf("%d %d\n", mx, my);
    }

  }


  // dotyczace check pointow
  if(m.klawiatura[K_SPACE]){

    // obrot
    if(m.klawiatura[K_ENTER]){
      m.klawiatura[K_ENTER] = false;
      point_rot = !point_rot;
    }

    // wybor numeru bramki - lewy gorny rog
    if(m.klawiatura[K_UP]){
      m.klawiatura[K_UP] = false;
      point_num++;
    }
    if(m.klawiatura[K_DOWN]){
      m.klawiatura[K_DOWN] = false;
      point_num--;
    }

    // wypalenie bramki na mapie
    if(m.myszka.lewy){
      mapa_point[my][mx] = (char)point_num*2 - point_rot;

      printf("%d %d - %d (%d)\n", mx, my, (mapa_point[my][mx]+1)/2,
	mapa_point[my][mx]);
    } 

  }

  // zapis do liku
  if(m.klawiatura['z']){
    m.klawiatura['z'] = false;

    // zapis terenu
    FILE *file = fopen(map_file, "wb");
    fwrite(mapa, 1, sizeof(mapa), file);
    fclose(file);
    printf("mapa zapisana!\n");

    // zapis itemow
    file = fopen(map_item_file, "wb");
    fwrite(mapa_item, 1, sizeof(mapa_item), file);
    fclose(file);
    printf("itemy zapisane!\n");
 

    // zapis check pointow
    file = fopen(map_point_file, "wb");
    fwrite(mapa_point, 1, sizeof(mapa_point), file);
    fclose(file);
    printf("check poitny zapisane!\n");
  

  }

}

void scena(){


  for(int y=0; y<HEIGHT; y++){
    for(int x=0; x<WIDTH; x++){

      // wyswietlanie terenu  
      ground.umiesc_ramke(
	20+x*40 + map_offset_x,
	20+y*40 + map_offset_y,
	mapa[y][x]);

      // wyswietlanie check pointow
      if(mapa_point[y][x])
        point.umiesc_ramke(
		20+x*40 + map_offset_x,
		20+y*40 + map_offset_y,
		(mapa_point[y][x])%2);



    }
  }






  // wyswietlanie stempelka do odcisniecia
  if(!m.klawiatura[K_SPACE]){
    ground.umiesc_ramke(
	20+mx*40 + map_offset_x,
	20+my*40 + map_offset_y,
	current_frame);
  }else{
     point.umiesc_ramke(
	20+mx*40 + map_offset_x,
	20+my*40 + map_offset_y,
	point_rot);
    
  }

  // wyswietlanie liczb
  int tmp = point_num;
  int i = 0;
  do{
    nums.umiesc_ramke(40 - i*9, 20, tmp%10);
    tmp /= 10;
    i++;
  }while(tmp);

}


int main(int argc, char **argv){
m.ustaw(logika,scena);pre();m.start();po();return 0;(void)argc;(void)argv;
}
