#include "fsdl.h"
#include <cmath>
#include <cstdio>

#define WIDTH  20
#define HEIGHT 12

fsdl m(100, 40*WIDTH, 40*HEIGHT, 32, "Test sil fizyki");


tekstura ground (m.okno(), "gfx/teren.bmp");
static char mapa[HEIGHT][WIDTH] = {0};

//float prom1 = 2;
//kolo  k1(m.okno(), prom1, 0xff0000);
//okrag k2(m.okno(), prom1, 0x0000ff);



tekstura car (m.okno(), "gfx/samochod.bmp", 0xff00ff);

float car_angle = 0.0;
//float car_angle_tmp = car_angle;
//                   x      y
float car_x[]   = {100.0, 400.0}; // pozycja (wektor x)
float car_v[]   = {0.0,   0.0};   // predkosc
float car_f[]   = {0.0,   0.0};   // sila ciagu
float car_m     = 15.0;            // masa pojazdu - wplywa na bezwladnosc

#define _X 0
#define _Y 1



// 180* = pi rad => 1* = pi/180 rad
// pi/180 rad => 1* w radianach
// a*PI/180 
float to_rad(float alfa){
  return alfa*M_PI/180;
}

float vec_mod2(float v[2]){
  return v[0]*v[0] + v[1]*v[1];
}


void pre(){


  // szybkie wczytanie mapy
  FILE* file = fopen("maps/1.map", "rb");
  fread(mapa, 1, sizeof(mapa), file);
  fclose(file);

  // ustawiam ramke wyswietlania dla tekstury ground
  ground.ustaw_ramke(40,40);
}

void po(){
 // narazie nic nie alokuje dynamicznie
}

void logika(){


   float vec_mod = sqrt(vec_mod2(car_v));

   // obracanie
   if(m.klawiatura[K_LEFT])  car_angle+= 0.7 * vec_mod;
   if(m.klawiatura[K_RIGHT]) car_angle-= 0.7 * vec_mod;
   // zapetlenie obrotu
   if(car_angle > 180.0)  car_angle -= 360.0;
   if(car_angle < -180.0) car_angle += 360.0;


   // gazu!
   if(m.klawiatura[K_UP]) {
	car_f[_X] = -0.2 * sin( to_rad(car_angle) );
	car_f[_Y] = -0.2 * cos( to_rad(car_angle) );
   }
   else if(m.klawiatura[K_DOWN]){
	car_f[_X] = 0.2 * sin( to_rad(car_angle) );
	car_f[_Y] = 0.2 * cos( to_rad(car_angle) );
   }

   else {car_f[_X] = 0.0; car_f[_Y] = 0.0;}


   // sila tarcia kol
   car_f[_X] += -0.17 * vec_mod * sin( to_rad(car_angle) );
   car_f[_Y] += -0.17 * vec_mod * cos( to_rad(car_angle) );


   //sila oporu powietrza
   // sila areodynamiczna D=-6PIv{mi}R dla kuli
   car_f[_X] -= car_v[_X] * 0.21;
   car_f[_Y] -= car_v[_Y] * 0.21;
 

   // Euler
   //            x(t)         v(t)dt      1/2 F(t)/m dt^2
   //   dt = 1
   car_x[_X] = car_x[_X] + car_v[_X] + car_f[_X]/(2*car_m);
   car_x[_Y] = car_x[_Y] + car_v[_Y] + car_f[_Y]/(2*car_m);

   car_v[_X] = car_v[_X] + car_f[_X]/(car_m);
   car_v[_Y] = car_v[_Y] + car_f[_Y]/(car_m);

}

void scena(){

  int mpx = 0;
  int mpy = 0;

  // rysowanie mapy
  for(int y=0; y<HEIGHT; y++){
    for(int x=0; x<WIDTH; x++){

     mpx = 20+x*40;
     mpy = 20+y*40;

     // wyswietlanie terenu tylko gdy znajduje sie w obszacze roboczym
     //if(mpx < m.szerokosc() && mpx > 0 && mpy < m.wysokosc() && mpy > 0)
       ground.umiesc_ramke(mpx,mpy, mapa[y][x]);
    }
  }


  car.obroc(car_angle);
  car.umiesc(car_x[_X], car_x[_Y]); 
  

  //prom1+=0.1;
  //k1.promien(prom1);
  //k2.promien(prom1);
  //k1.umiesc(m.szerokosc()/2, m.wysokosc()/2);
  //k2.umiesc(300, 300);

}


int main(int argc, char **argv){
m.ustaw(logika,scena);pre();m.start();po();return 0;(void)argc;(void)argv;
}
