/*
* Copyright (c) 2006-2007 Erin Catto http://www.box2d.org
*
* This software is provided 'as-is', without any express or implied
* warranty.  In no event will the authors be held liable for any damages
* arising from the use of this software.
* Permission is granted to anyone to use this software for any purpose,
* including commercial applications, and to alter it and redistribute it
* freely, subject to the following restrictions:
* 1. The origin of this software must not be misrepresented; you must not
* claim that you wrote the original software. If you use this software
* in a product, an acknowledgment in the product documentation would be
* appreciated but is not required.
* 2. Altered source versions must be plainly marked as such, and must not be
* misrepresented as being the original software.
* 3. This notice may not be removed or altered from any source distribution.
*/

#include <Box2D/Box2D.h>

#include <stdio.h>

// This is a simple example of building and running a simulation
// using Box2D. Here we create a large ground box and a small dynamic
// box.
// There are no graphics for this example. Box2D is meant to be used
// with your rendering engine in your game engine.
int main(int argc, char** argv)
{
	/*B2_NOT_USED(argc);
	B2_NOT_USED(argv);*/

	//Grawitacja jest reprezentowana przez wektor 2D, jako parametry przyjmuje wsprzdne,
	//Co pozwala na okreslenie dowolnego kierunku jej dzialania, a nam daje mozliwosc tworzenia 
	//swiatw fizycznych ktore reaguj na akcelerometry w smartfonach(odczytujac ich wartosc mozna ustalic kierunek)
	b2Vec2 gravity(0.0f, -10.0f);
	
	//2 Parametr konstruktora klasy b2World , Okresla czy obiekty podczas symulacji mog "zasnc"
	//Co w praktyce oznacz ze jesli przekazemy do konstruktora true , bedziemy w stanie "wyczyc"
	//je z czsci obliczen
	bool doSleep = true;
	
	//klasa b2World jest podstaw biblioteki box2D jest zwana wiatem, Obiekt b2World jest kontenerem
	//dla wszystkich podrzdnych obiektw
	//drugi parametr setAllowSleep - ozncza to tyle ze bedziemy w stanie wyczyc pewne obiekty z symulacji
	b2World world(gravity,true);
	
	
	//Definiowanie struktury na podstawie ktorej powstanie ciao podoza
	//Struktura ma Wszystkie wartoci domylne, Z domyslnymi parametrami zostanie stworzona struktura
	//ciaa w punkcie (0,0) ukadu wsprzdnych
	b2BodyDef groundBodyDef;
	groundBodyDef.position.Set(0.0f, 0.0f);
	
	//groundBodyDef.type = b2_dynamicBody;		//Ma mase, podlega dziaaniom si grawitacji, moze zostac wprawione w ruch
												//Moze kolidowac z innymi ciaami dynamicznymi lub statycznymi
												//Pojazdy, pociski,kule bilardowe
	
	//groundBodyDef.type = b2_staticBody;		//Nie ma masy nie podlega dziaaniom adnych si, nie moze zostac
												//Wprawione w ruch.Wykorzystywane s jako elementy wyznaczajce 
												//Pole gry np boisko, bandy, sciany
	
	//groundBodyDef.type = b2_kinematicBody;	//Nie podlega dzialaniom si, moze zostac wprawione w ruch liniowy i rotacyjny
												//Moze kolidowac z innymi ciaami dynamicznymi ale nie z kinematycznymi
												//Mozna je stosowac jako ciekie platformy ktore nie reaguje na ciezkie ciaa kolidujace z nimi
	//Poza typem ciaa maj jeszcze inne wasciwosci, Kazdy z tych parametrow mozna regulowac rowniez 
	//po utworzeniu ciaa
	
	
	
	//Domyslnie Zostaje stworzone ciao typu statycznego,na podstawie struktury-podanej jako argument
	// w punkcie (0,0)ukadu wsprzdnych wiata rowniez domyslnie.
	//i dodane do listy obiektw wiata
	b2Body* groundBody = world.CreateBody(&groundBodyDef);
	
	

	// Klasa b2Shape jest klas bazow dla czterech klas konstruujcych geometryczny opis obiektw
	
	//Maj okreslon mase i mog miec przypisan mase , Mog byc ciaami dynamicznymi lub kinematycznymi
	//b2CircleShape		
	//b2PolygonShape
	
	//Nie maj powierzchni, jednopixelowe odcinki tylko ciaa statyczne
	//b2EdgeShape
	//b2ChainShape
	b2PolygonShape groundBox;

	// Pomocnicza metoda tworzca prostoktny krztat zamiast .Set(i po kolei kazdy wierzcholek)
	groundBox.SetAsBox(1.0f, 1.0f); //jako argumenty podajemy poow wysokosci i szerokosci tworzonego prostokata

	
	//klasa b2Fixture zawira informacje fizyczne o ciele takie jak geometryczna reprezentacja,
	//gestosc wynikajaca z niej masa, rodek ciezkosci, wsp tarcia, wsp odbica
	//Metoda CreateFixture ma dw warianty , 
	//b2Fixture* CreateFixture(const b2Shape* shape, float32 density);
	//b2Fixture* CreateFixture(const b2FixtureDef* def);


	// Tutaj jest tworzona reprezentacja fizyczna ciaa, Jako parametry pobiera obiekt b2Shape i gsto
	groundBody->CreateFixture(&groundBox, 0.0f);

	
	// Definujemy Nowy obiekt Dynamiczny
	b2BodyDef bodyDef;
	bodyDef.type = b2_dynamicBody;
	bodyDef.position.Set(0.0f, 4.0f);
	b2Body* body = world.CreateBody(&bodyDef);

	// Define another box shape for our dynamic body.
	b2PolygonShape dynamicBox;
	dynamicBox.SetAsBox(1.0f, 1.0f);

	// Define the dynamic body fixture.
	b2FixtureDef fixtureDef;
	fixtureDef.shape = &dynamicBox;
	//fixtureDef.restitution = 0.3f; //- wsp odbicia

	// ustalamy gstoc
	fixtureDef.density = 1.0f;

	// tarcie
	fixtureDef.friction = 0.3f;

	// 2 wariant CreateFixture. tutaj jako parametr przekazujemy strukture b2FixtureDef, i tak tworzony jest obiekt b2Fixture
	//Dodajemy wasciwosci do ciaa dynamicznego
	body->CreateFixture(&fixtureDef);

	// Prepare for simulation. Typically we use a time step of 1/60 of a
	// second (60Hz) and 10 iterations. This provides a high quality simulation
	// in most game scenarios.
	float32 timeStep = 1.0f / 60.0f;
	int32 velocityIterations = 3;
	int32 positionIterations = 8;

	// ptla gry
	for (int32 i = 0; i < 60; ++i)
	{
		//Wewntrz tej metody wykonywana jest caa symulacja fizyczna dla wszystkich 
		//elementw wiata
		world.Step(timeStep, velocityIterations, positionIterations);

		// Now print the position and angle of the body.
		b2Vec2 position = body->GetPosition();
		float32 angle = body->GetAngle();

		printf("%4.2f %4.2f %4.2f\n", position.x, position.y, angle);
	}
	int a;
	scanf_s("%d", &a);
	// When the world destructor is called, all bodies and joints are freed. This can
	// create orphaned pointers, so be careful about your world management.

	return 0;
}
