#define GLUT_DISABLE_ATEXIT_HACK 
#include <string>
#include <stdio.h>

#include <iostream>
#include <glew.h>
#include <freeglut.h>
#include "shader.h"
#include <glm.hpp>
#include <gtc\matrix_transform.hpp>
#include <gtc\type_ptr.hpp>
#include <gtx\transform.hpp>
#include <math.h>
#include "Camera.h"
#include "SPHSystem.h"
#include "particlesystem.h"
#include "grid.h"

Shader shader_obj;
SPHSystem* sph;
ParticleSystem* ps;
Camera cam;




int gwidth = 640;
int gheight = 480; 
//Keyboard variables
bool keyStates[256];


//Shader var locations
int position_loc = -1;			// Initialize location to -1 
int color_loc= -1;			
int projection_loc = -1;
int texture_loc = -1;
int texcoord_loc = -1;
int normal_loc = -1;

//Transformation Matrices
glm::mat4 model = glm::translate(glm::mat4(1.0f), glm::vec3(0.0, 0.0, 0.0));
glm::mat4 rot = glm::rotate(model, 45.f, glm::vec3(1, 0, 0));

//Buffers
GLuint vertexBuffers;
GLuint indexBuffers;
GLuint colorBuffers;
GLuint particleBuffers;
GLuint textureId; 
GLuint texcoord; 
glm::vec3 *partPos; 


void InitializeProgram()
{
	shader_obj.add(GL_VERTEX_SHADER, "vs.glsl");
	shader_obj.add(GL_FRAGMENT_SHADER, "fs.glsl");
	shader_obj.CompileProgram();
	shader_obj.deleteShaders();
}

void getShaderVarLoc()
{
	position_loc = shader_obj.getAttributeLocation("position");
	color_loc = shader_obj.getAttributeLocation("color");
	texcoord_loc = shader_obj.getAttributeLocation("texcoord");
	projection_loc = shader_obj.getUniformLoc("projection");
	texture_loc = shader_obj.getUniformLoc("gtexture");
	normal_loc = shader_obj.getUniformLoc("normal");


}

void initCamera(){
	cam.setWindowCoords(gwidth, gheight);
	cam.init();
	cam.setFov(60.0f);
	cam.setAspRatio(gwidth/gheight);
	cam.setNearFar(0.1f, 5000.f);
	cam.setPosition(glm::vec3(.64, .64, .15));
	cam.lookAt(glm::vec3(.64, 0.64, 0.1));
	cam.setVelocity(1);
	glutWarpPointer(cam.mMouseX, cam.mMouseY);

}

void toPerspective()
{
	// set viewport to be the entire window
	glViewport(0, 0, (GLsizei)gwidth, (GLsizei)gheight);

	// set perspective viewing frustum
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	gluPerspective(60.0f, (float)(gwidth) / gheight, 1.0f, 1000.0f); // FOV, AspectRatio, NearClip, FarClip

	// switch to modelview matrix in order to set scene
	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
}

void reshapeCB(int w, int h)
{
	gwidth = w;
	gheight = h;
	toPerspective();
}



void initLights()
{
	// set up light colors (ambient, diffuse, specular)
	GLfloat lightKa[] = { .2f, .2f, .2f, 1.0f };  // ambient light
	GLfloat lightKd[] = { .7f, .7f, .7f, 1.0f };  // diffuse light
	GLfloat lightKs[] = { 1, 1, 1, 1 };           // specular light
	glLightfv(GL_LIGHT0, GL_AMBIENT, lightKa);
	glLightfv(GL_LIGHT0, GL_DIFFUSE, lightKd);
	glLightfv(GL_LIGHT0, GL_SPECULAR, lightKs);

	// position the light
	float lightPos[4] = { 0, 0, 20, 1 }; // positional light
	glLightfv(GL_LIGHT0, GL_POSITION, lightPos);

	glEnable(GL_LIGHT0);                        // MUST enable each light source after configuration
}

void initOpengl()
{
	glEnable(GL_DEPTH_TEST);
	glEnable(GL_LIGHTING);
	glEnable(GL_TEXTURE_2D);
	glEnable(GL_CULL_FACE);

	// track material ambient and diffuse from surface color, call it before glEnable(GL_COLOR_MATERIAL)
	glColorMaterial(GL_FRONT_AND_BACK, GL_AMBIENT_AND_DIFFUSE);
	glEnable(GL_COLOR_MATERIAL);
	glClearColor(0, 0, 0, 0);                   // background color
	glClearStencil(0);                          // clear stencil buffer
	glClearDepth(1.0f);                         // 0 is near, 1 is far
	glDepthFunc(GL_LEQUAL);

	InitializeProgram();

	initCamera();
	getShaderVarLoc();
	
	sph = new SPHSystem();
	sph->init();

	initLights();

	//grid = new Grid(glm::vec3(.64,.64,0), 1.28, 1.28, 0.04);
}

void processKeyboard(float dt)
{
	if (keyStates['R'] || keyStates['r'])
	{
		sph->init();
		sph->update();
	}
	if (keyStates['P'] || keyStates['p'])
	{
	}
	else 
	{
		sph->update();
	}

	//jak za wolno skocz do nastepnego kroku
	if (keyStates['F'] || keyStates['f'])
	{
		sph->step();
	}

	//ogladaj klatka po klatce
	if(keyStates['u'] || keyStates['U'])
	{
		sph->update();
	}
	

	if(keyStates['a'] || keyStates['A'])
	{
		cam.offsetPosition(cam.velocity()*dt*-cam.right());
	}

	if(keyStates['s'] || keyStates['S'])
	{
		cam.offsetPosition(cam.velocity()*dt*-cam.forward());
	}

	if(keyStates['w'] || keyStates['W'])
	{
		cam.offsetPosition(cam.velocity()*dt*cam.forward());
	}

	if(keyStates['d'] || keyStates['D'])
	{
		cam.offsetPosition(cam.velocity()*dt*cam.right());
	}

	if(keyStates['j'] || keyStates['J'])
	{
		cam.offsetOrientation(0.0f, -0.05f);
		//rot = glm::rotate(rot,-1.f, glm::vec3(0.0, 1.0, 0.0));
	}

	if(keyStates['l'] || keyStates['L'])
	{
		cam.offsetOrientation(0.0f, 0.05f);
		//rot = glm::rotate(rot ,1.f, glm::vec3(0.0, 1.0, 0.0));
	}
	if(keyStates['k'] || keyStates['k'])
	{
		cam.offsetOrientation(-0.05f, 0.0f);
		//rot = glm::rotate(rot,-1.f, glm::vec3(1.0, 0.0, 0.0));
	}

	if(keyStates['i'] || keyStates['I'])
	{
		cam.offsetOrientation(0.05f, 0.0f);
		//rot = glm::rotate(rot ,1.f, glm::vec3(1.0, 0.0, 0.0));
	}

}

void check()
{
	GLenum err = glGetError();
	std::cout<<gluErrorString(err)<<std::endl;
}

void display()
{
	glPolygonMode( GL_BACK, GL_LINE );
	//clear screen
	glClearColor(1.0f, 1.0f, 1.0f, 1.0f);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT | GL_STENCIL_BUFFER_BIT);

	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();
	


	glMatrixMode(GL_MODELVIEW);
	glLoadIdentity();
	glDisable(GL_DEPTH_TEST);
	glBegin(GL_QUADS);
	glColor3f(0.399, 0.4, 0.4);
	glVertex3f(1.0, 1.0,0.9);
	glVertex3f(-1.0, 1.0, 0.9);

	glColor3f(0.55, 0.55, 0.55);
	glVertex3f(-1.0, -1.0, 0.9);
	glVertex3f(1.0, -1.0, 0.9);
	

	glEnd();
	/*glDepthFunc(GL_LEQUAL);
	glHint(GL_PERSPECTIVE_CORRECTION_HINT, GL_NICEST);
	glEnable(GL_DEPTH_TEST);
	glDepthFunc(GL_LESS);
	glEnable(GL_DEPTH_TEST);*/
	//glAccum(GL_RETURN, 0.95f);

//	glClear(GL_ACCUM_BUFFER_BIT);

	//use shader program for subsequent calls
	glEnable(GL_DEPTH_TEST);
	shader_obj.useProgram();

	model = glm::mat4(1.0f);
	model = glm::translate(model, glm::vec3(0.0, 0.0, 0.0));
	
	glm::mat4 m = cam.matrix();
	
	//Pass uniforms to shader
	if(projection_loc != -1)
		glUniformMatrix4fv(projection_loc, 1, false, glm::value_ptr(m));

	//p->LoadView(cam.matrix());	
	//p->LoadIdentity();
	
	//Enable the position location in the shader
	glEnableVertexAttribArray(position_loc);
	//glEnableVertexAttribArray(color_loc);
	
	
	glPointSize(15.0);

	
	sph->render(position_loc, cam);
	//grid->render(position_loc, color_loc, normal_loc);


	
	
	glUseProgram(0);

	glDisableVertexAttribArray(position_loc);
	//glDisableVertexAttribArray(color_loc);
	
	glutPostRedisplay();
	glutSwapBuffers();
	//glAccum(GL_ACCUM, 0.9f);
}

void idle()
{
	static int last_time = 0;
	int time = glutGet(GLUT_ELAPSED_TIME);
	int elapsed = time-last_time;
	float dt= 0.003;// * elapsed;
	last_time = time;
	processKeyboard(dt);
} 

void reshape (int w, int h)
{
	gwidth = w;
	gheight = h; 

	glViewport(0, 0, (GLsizei) w, (GLsizei) h);
}

void keyboard(unsigned char key, int x, int y)
{
	switch (key)
	{
	  case 27:
		  glutLeaveMainLoop();
		  return;
	}
	keyStates[key] = true;
}

void keyboardUp(unsigned char key, int x, int y)
{
	keyStates[key] = false;
}

void mwheel(int wheel, int direction, int x, int y)
{
	float dt = 0.03;
	if (direction >0) // It's a wheel event
	{
		cam.offsetPosition(cam.velocity()*dt*cam.forward());
	}
	else {
		cam.offsetPosition(cam.velocity()*dt*-cam.forward());
	}
}
float deltaAngle = 0.0f;
int xOrigin = -1;



void passiveMotion(int x, int y)
{
	//cam.onMouseMove(x, y);
}
void motion(int x, int y)
{
	cam.onMouseMove(x, y);
}

void mouse(int button, int state, int x, int y)
{
	if ((button == GLUT_LEFT_BUTTON) && (state=GLUT_UP)) {
		motion(x, y);
	}
}



void createGlutCallBacks()
{
	glutDisplayFunc(display);
	glutReshapeFunc(reshape);
	glutKeyboardFunc(keyboard);
	glutKeyboardUpFunc(keyboardUp);
	glutReshapeFunc(reshape);
	glutMouseWheelFunc(mwheel);
	glutMouseFunc(mouse);
	glutPassiveMotionFunc(passiveMotion);
	glutMotionFunc(motion);
	glutIdleFunc(idle);
}
void draw1()
{
	glPushMatrix();
	glTranslatef(-2, 2, 0); // move to upper left corner
	glBegin(GL_TRIANGLES);
	// front faces
	glNormal3f(0, 0, 1);
	// face v0-v1-v2
	glColor3f(1, 1, 1);
	glVertex3f(1, 1, 1);
	glColor3f(1, 1, 0);
	glVertex3f(-1, 1, 1);
	glColor3f(1, 0, 0);
	glVertex3f(-1, -1, 1);
	// face v2-v3-v0
	glColor3f(1, 0, 0);
	glVertex3f(-1, -1, 1);
	glColor3f(1, 0, 1);
	glVertex3f(1, -1, 1);
	glColor3f(1, 1, 1);
	glVertex3f(1, 1, 1);

	// right faces
	glNormal3f(1, 0, 0);
	// face v0-v3-v4
	glColor3f(1, 1, 1);
	glVertex3f(1, 1, 1);
	glColor3f(1, 0, 1);
	glVertex3f(1, -1, 1);
	glColor3f(0, 0, 1);
	glVertex3f(1, -1, -1);
	// face v4-v5-v0
	glColor3f(0, 0, 1);
	glVertex3f(1, -1, -1);
	glColor3f(0, 1, 1);
	glVertex3f(1, 1, -1);
	glColor3f(1, 1, 1);
	glVertex3f(1, 1, 1);

	// top faces
	glNormal3f(0, 1, 0);
	// face v0-v5-v6
	glColor3f(1, 1, 1);
	glVertex3f(1, 1, 1);
	glColor3f(0, 1, 1);
	glVertex3f(1, 1, -1);
	glColor3f(0, 1, 0);
	glVertex3f(-1, 1, -1);
	// face v6-v1-v0
	glColor3f(0, 1, 0);
	glVertex3f(-1, 1, -1);
	glColor3f(1, 1, 0);
	glVertex3f(-1, 1, 1);
	glColor3f(1, 1, 1);
	glVertex3f(1, 1, 1);

	// left faces
	glNormal3f(-1, 0, 0);
	// face  v1-v6-v7
	glColor3f(1, 1, 0);
	glVertex3f(-1, 1, 1);
	glColor3f(0, 1, 0);
	glVertex3f(-1, 1, -1);
	glColor3f(0, 0, 0);
	glVertex3f(-1, -1, -1);
	// face v7-v2-v1
	glColor3f(0, 0, 0);
	glVertex3f(-1, -1, -1);
	glColor3f(1, 0, 0);
	glVertex3f(-1, -1, 1);
	glColor3f(1, 1, 0);
	glVertex3f(-1, 1, 1);

	// bottom faces
	glNormal3f(0, -1, 0);
	// face v7-v4-v3
	glColor3f(0, 0, 0);
	glVertex3f(-1, -1, -1);
	glColor3f(0, 0, 1);
	glVertex3f(1, -1, -1);
	glColor3f(1, 0, 1);
	glVertex3f(1, -1, 1);
	// face v3-v2-v7
	glColor3f(1, 0, 1);
	glVertex3f(1, -1, 1);
	glColor3f(1, 0, 0);
	glVertex3f(-1, -1, 1);
	glColor3f(0, 0, 0);
	glVertex3f(-1, -1, -1);

	// back faces
	glNormal3f(0, 0, -1);
	// face v4-v7-v6
	glColor3f(0, 0, 1);
	glVertex3f(1, -1, -1);
	glColor3f(0, 0, 0);
	glVertex3f(-1, -1, -1);
	glColor3f(0, 1, 0);
	glVertex3f(-1, 1, -1);
	// face v6-v5-v4
	glColor3f(0, 1, 0);
	glVertex3f(-1, 1, -1);
	glColor3f(0, 1, 1);
	glVertex3f(1, 1, -1);
	glColor3f(0, 0, 1);
	glVertex3f(1, -1, -1);
	glEnd();

	glPopMatrix();
}

int main(int argc, char** argv)
{
	glutInit(&argc, argv); 
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGBA | GLUT_DEPTH | GLUT_ACCUM);
	glutInitWindowSize(gwidth,gheight);
	glutInitWindowPosition(100, 10);
	glutCreateWindow("Physika - Particle Systems");
	glutReshapeFunc(reshapeCB);
	createGlutCallBacks();
	GLenum res = glewInit();
	if(res != GLEW_OK)
	{
		fprintf(stderr, "Error: '%s'\n", glewGetErrorString(res));
		return 1;
	}
	initOpengl();

	glutMainLoop();
	return 0;
}

//#version 120
//uniform sampler2D tex0;
//uniform float border; // 0.01
//uniform float circle_radius; // 0.5
//uniform vec4 circle_color; // vec4(1.0, 1.0, 1.0, 1.0)
//uniform vec2 circle_center; // vec2(0.5, 0.5)    
//void main(void)
//{
//	vec2 uv = gl_TexCoord[0].xy;
//
//	vec4 bkg_color = texture2D(tex0, uv * vec2(1.0, -1.0));
//
//	 Offset uv with the center of the circle.
//	uv -= circle_center;
//
//	float dist = sqrt(dot(uv, uv));
//	if ((dist > (circle_radius + border)) || (dist < (circle_radius - border)))
//		gl_FragColor = bkg_color;
//	else
//		gl_FragColor = circle_color;
//}