#include "stdafx.h"
#include "OpenGL.h"

#include <Windows.h>
const GLdouble left = -1.0;
const GLdouble right = 1.0;
const GLdouble bottom = -1.0;
const GLdouble top = 1.0;
const GLdouble nearr = 3.0;
const GLdouble farr = 7.0;

GLfloat rotateX = 0.0;
GLfloat rotateY = 0.0;

int leftMouseButtonState = GLUT_UP;
int mousePositionX, mousePositionY;
int scale = 1.00;
int normalVectors = GLU_SMOOTH;
int orientation = GLU_OUTSIDE;
int style = GLU_FILL;
int aspect = 0;

int frame = 0;
const static int posScale = 3;

std::ifstream config;

int qParticles, frames, qVessle;

Pos *particlePos;
Pos *vesslePos;

void createSphere(float x, float y, float z, bool water)
{
	glTranslatef(x, y, z);
	if (water) 
	if (x / posScale > vesslePos->x[0] && x / posScale < vesslePos->x[qVessle - 1]
		&& z / posScale > vesslePos->z[0] && z / posScale < vesslePos->z[qVessle - 1]
			&& y < vesslePos->y[0])
		{
			glColor3f(1, 0, 0);
		}
		else
		{
			glColor3f(0, 1, 1);
		}
	else glColor3f(0.5, 0.5, 0.5);
	glutSolidSphere(0.013, 10, 10);
	glTranslatef(-x, -y, -z);
}

void DrawString(int x, int y, char * string)
{
	// pooenie napisu
	glRasterPos2i(x, y);

	// wywietlenie napisu
	int len = strlen(string);
	for (int i = 0; i < len; i++)
		glutBitmapCharacter(GLUT_BITMAP_9_BY_15, string[i]);

}

void createParticles()
{
	for (long int i = frame * qParticles; i < qParticles + frame * qParticles; i++)
	{
		createSphere(particlePos->x[i] * posScale, particlePos->y[i] * posScale, particlePos->z[i] * posScale, true);
		//std::cout << particles.x[i] * 100 << "\t" << particles.y[i] * 100 << "\t" << particles.z[i] * 100 << std::endl;
	}
	for (int i = 0; i < qVessle; i++)
	{
		createSphere(vesslePos->x[i] * posScale, vesslePos->y[i] * posScale, vesslePos->z[i] * posScale, false);
		//std::cout << particles.x[i] * 100 << "\t" << particles.y[i] * 100 << "\t" << particles.z[i] * 100 << std::endl;
	}
	//Sleep(5);

	char stri[10000];
	sprintf_s(stri, "%d / %d", frame, frames);

	glutSetWindowTitle(stri);

	//DrawString(0.8, 0.8, stri);
	if (frame < frames) {
		frame++; 
	}
	else 
		frame = 0;
}

void create3DScene()
{
	glClearColor(1.0, 1.0, 1.0, 1.0);
	glClear(GL_COLOR_BUFFER_BIT | GL_DEPTH_BUFFER_BIT);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	glEnable(GL_DEPTH_TEST);
	//glEnable(GL_LIGHTING);
	glEnable(GL_LIGHT0);
	glEnable(GL_NORMALIZE);

	glRotatef(rotateX, 1.0, 0, 0);
	glRotatef(rotateY, 0, 1.0, 0);
	glScalef(scale, scale, scale);

	glBegin(GL_LINES);
	glVertex3d(0, 0, 0);
	glVertex3d(1, 0, 0);
	glEnd();
	glBegin(GL_LINES);
	glVertex3d(0, 0, 0);
	glVertex3d(0, 1, 0);
	glEnd();
	glBegin(GL_LINES);
	glVertex3d(0, 0, 0);
	glVertex3d(0, 0, 1);
	glEnd();

	createParticles();

	//glDisable(GL_LIGHTING);
	glDisable(GL_DEPTH_TEST);

	glLoadIdentity();
	glFlush();
	glutSwapBuffers();
}
void reshape3DScene(int width, int height) {
	glViewport(0, 0, width, height);
	glMatrixMode(GL_PROJECTION);
	glLoadIdentity();

	if (aspect == 1)
	{
		if (width < height && width > 0)
			glFrustum(left, right, bottom * height / width, top * height / width, nearr, farr);
		else if (width >= height && height > 0)
			glFrustum(left * width / height, right * width / height, bottom, top, nearr, farr);
	}
	else
		glFrustum(left, right, bottom, top, nearr, farr);

	create3DScene();
}
void mouseButtonControl(int button, int state, int x, int y)
{
	if (button == GLUT_LEFT_BUTTON)
	{
		leftMouseButtonState = state;
		if (state == GLUT_DOWN)
		{
			mousePositionX = x;
			mousePositionY = y;
		}
	}
}
void mouseMotionControl(int x, int y)
{
	if (leftMouseButtonState == GLUT_DOWN)
	{
		rotateY += 30 * (right - left) / glutGet(GLUT_WINDOW_WIDTH) *(x - mousePositionX);
		mousePositionX = x;
		rotateX -= 30 * (top - bottom) / glutGet(GLUT_WINDOW_HEIGHT) *(mousePositionY - y);
		mousePositionY = y;
		glutPostRedisplay();
	}
}

OpenGL::OpenGL(int argc, char** argv)
{
	config.open("config.cfg");
	config >> frames;
	config >> qParticles;
	config >> qVessle;
	config.close();

	particlePos = new Pos(frames, qParticles, "pozycje.dat");
	vesslePos = new Pos(1, qVessle, "naczynie.dat");

	glutInit(&argc, argv);
	glutInitDisplayMode(GLUT_DOUBLE | GLUT_RGB | GLUT_DEPTH);
	glutInitWindowSize(800, 600);
	glutCreateWindow("Symulacja");

	glutDisplayFunc(create3DScene);
	glutReshapeFunc(reshape3DScene);
	glutMouseFunc(mouseButtonControl);
	glutMotionFunc(mouseMotionControl);
	glutIdleFunc(create3DScene);
	
	glutMainLoop();

}


OpenGL::~OpenGL()
{
}

