#include "Vector2D.h"
#include "Kulki.h"

#define PI 3.141592
#define INF pow(10,-12)

class SimulationSPH
{
public:
	SimulationSPH();
	~SimulationSPH();
	void init_ciecz();
	void dodaj_kulke(Vecf poz, Vecf pred);
	Veci calculate_pos(Vecf poz);
	uint licz_siatke(Veci poz);

	//mysz
	float mysz_x=0.0;
	float mysz_y=0.0;

	//kernel
	float ker_poly6(float r2){ return 315.0f/(64.0f * PI * pow(kernel, 9)) * pow(kernel*kernel-r2, 3); }
	float ker_spiky(float r){ return -45.0f/(PI * pow(kernel, 6)) * (kernel-r) * (kernel-r); }
	float ker_visco(float r){ return 45.0f/(PI * pow(kernel, 6)) * (kernel-r); }

	////////



	//animacja
	void step();
	void buduj();
	void licz_cisnienie_gestosc();
	void licz_sil();
	void adwekcja();
	void animacja();
	//////////////////////////////////////////////////////////////////////////////////////////////////
	
	uint get_num_particles(){ return liczba_kulek; }
	Vecf get_wind_size(){ return wielkosc_sw; }
	Kulka* get_particles(){ return particles; }
	Kom* get_cells(){ return cells; }


private:
	float kernel;
	float masa;

	uint max_kulek;
	uint liczba_kulek;

	Veci wielkosc_siatki;
	Vecf wielkosc_sw;
	float wielkosc_cell;
	uint total_cell;

	//parametry
	Vecf grawitacja;
	float stiff;
	float par_rest_dens;
	float par_time_stp;
	float par_wall_dumping;
	float par_visco;

	Kulka *particles;
	Kom *cells;
};


