
#ifndef __VECTOR2D_H__
#define __VECTOR2D_H__

#include <math.h>

typedef unsigned int uint;

class Vecf
{
public:
	float x;
	float y;

public:
	Vecf() {}
	Vecf(float _x, float _y) { x=_x; y=_y; };
	Vecf(Vecf &w) { x=w.x; y=w.y; };

	Vecf operator +(const Vecf &w) const { return Vecf(x+w.x, y+w.y); }
	Vecf operator -(const Vecf &w) const { return Vecf(x-w.x, y-w.y); }
	Vecf operator *(const Vecf &w) const { return Vecf(x*w.x, y*w.y); }
	Vecf operator /(const Vecf &w) const { return Vecf(x/w.x, y/w.y); }

	friend  Vecf operator +(const Vecf &w, float n) { return Vecf(w.x+n, w.y+n); }
	friend  Vecf operator -(const Vecf &w, float n) { return Vecf(w.x-n, w.y-n); }
	friend  Vecf operator *(const Vecf &w, float n) { return Vecf(w.x*n, w.y*n); }
	friend  Vecf operator /(const Vecf &w, float n) { return Vecf(w.x/n, w.y/n); }

	friend  Vecf operator +(float n, const Vecf &w) { return Vecf(n+w.x, n+w.y); }
	friend  Vecf operator -(float n, const Vecf &w) { return Vecf(n-w.x, n-w.y); }
	friend  Vecf operator *(float n, const Vecf &w) { return Vecf(n*w.x, n*w.y); }
	friend  Vecf operator /(float n, const Vecf &w) { return Vecf(n/w.x, n/w.y); }

	float punk(const Vecf &vec) const { return x*vec.x+y*vec.y; }
	Vecf gNormalize() const { return  *this / dlug();} 
	void Normalize() { *this = *this / dlug(); }

	float dlugKwadr() const { return x*x+y*y; }
	float dlug() const { return sqrt(dlugKwadr()); }
};

class Veci
{
public:
	int x;
	int y;

public:
	Veci(){}
	Veci(int _x, int _y){ x=_x; y=_y; }
	Veci(Veci &w) { x=w.x; y=w.y; }
};

class Vecu
{
public:
	uint x;
	uint y;

public:
	Vecu(){}
	Vecu(uint _x, uint _y){ x=_x; y=_y; }
	Vecu(Vecu &w) { x=w.x; y=w.y; }
};

#endif
