//Wersja oryginalna (Delphi 3)
//Wersja poprawiona (JM, 5.04.2003)

unit FuncGraph;

interface

uses
  Windows, Messages, SysUtils, Classes, Graphics, Controls, Forms, Dialogs;

type
  fg_ftyp = double;
  TUserFunc = procedure(X: fg_ftyp; var Y: fg_ftyp; var PointVisible :Boolean) of Object;
  TFuncGraph = class(TGraphicControl)
  private
    FRangeMinX: fg_ftyp;
    FRangeMaxX: fg_ftyp;
    FRangeMinY: fg_ftyp;
    FRangeMaxY: fg_ftyp;
    FUserFunc: TUserFunc;
    FAddUserFunc: TUserFunc;
    FPlotPen: TPen;
    FAddPlotPen: TPen;
    FBorderPen: TPen;
    FZeroAxisPen: TPen;
    FXZeroAxis: Boolean;
    FYZeroAxis: Boolean;
    FBackgroundBrush: TBrush;
    procedure SetPlotPen(Value :TPen);
    procedure SetAddPlotPen(Value :TPen);
    procedure SetBorderPen(Value :TPen);
    procedure SetZeroAxisPen(Value :TPen);
    procedure SetBackgroundBrush(Value :TBrush);
  protected
    //
  public
    constructor Create(AOwner: TComponent); override;
    destructor Destroy; override;
    procedure Paint; override;
  published
    property RangeMinX: fg_ftyp read FRangeMinX write FRangeMinX;
    property RangeMaxX: fg_ftyp read FRangeMaxX write FRangeMaxX;
    property RangeMinY: fg_ftyp read FRangeMinY write FRangeMinY;
    property RangeMaxY: fg_ftyp read FRangeMaxY write FRangeMaxY;
    property OnUserFunc: TUserFunc read FUserFunc write FUserFunc;
    property OnAddUserFunc: TUserFunc read FAddUserFunc write FAddUserFunc;
    property Width default 50;
    property Height default 50;
	property PlotPen: TPen read FPlotPen write SetPlotPen;
    property AddPlotPen: TPen read FAddPlotPen write SetAddPlotPen;
    property BorderPen: TPen read FBorderPen write SetBorderPen;
    property ZeroAxisPen: TPen read FZeroAxisPen write SetZeroAxisPen;
    property XZeroAxis: Boolean read FXZeroAxis write FXZeroAxis;
    property YZeroAxis: Boolean read FYZeroAxis write FYZeroAxis;
    property BackgroundBrush: TBrush read FBackgroundBrush write SetBackgroundBrush;
    procedure StyleChanged(Sender: TObject);
  end;

procedure Register;

implementation

procedure Register;
begin
  RegisterComponents('JM', [TFuncGraph]);
end;

constructor TFuncGraph.Create(AOwner: TComponent);
begin
 inherited Create(AOwner);
 Height := 50;
 Width := 50;
 FRangeMaxX := 1;
 FRangeMaxY := 1;
 ShowHint := True;
 FPlotPen:=TPen.Create;
 FAddPlotPen:=TPen.Create;
 FAddPlotPen.Style:=psDash;
 FBorderPen:=TPen.Create;
 FZeroAxisPen:=TPen.Create;
 FZeroAxisPen.Color:=RGB(200,200,200);
 FBackgroundBrush:=TBrush.Create;
 FPlotPen.OnChange:=StyleChanged;
 FAddPlotPen.OnChange:=StyleChanged;
 FBorderPen.OnChange:=StyleChanged;
 FZeroAxisPen.OnChange:=StyleChanged;
 FBackgroundBrush.OnChange:=StyleChanged;
end;

destructor TFuncGraph.Destroy;
begin
	FPlotPen.Free;
	FAddPlotPen.Free;
    FBorderPen.Free;
    FZeroAxisPen.Free;
    FBackgroundBrush.Free;
    inherited Destroy;
end;

procedure TFuncGraph.SetPlotPen(Value: TPen);
begin
  FPlotPen.Assign(Value);
end;

procedure TFuncGraph.SetAddPlotPen(Value: TPen);
begin
  FAddPlotPen.Assign(Value);
end;

procedure TFuncGraph.SetBorderPen(Value: TPen);
begin
  FBorderPen.Assign(Value);
end;

procedure TFuncGraph.SetZeroAxisPen(Value: TPen);
begin
  FZeroAxisPen.Assign(Value);
end;

procedure TFuncGraph.SetBackgroundBrush(Value: TBrush);
begin
  FBackgroundBrush.Assign(Value);
end;

procedure TFuncGraph.StyleChanged(Sender: TObject);
begin
  Invalidate;
end;

procedure TFuncGraph.Paint;
var
 X, Y: Integer; { wsprzedne wykresu (w pikselach) }
 RX, RY: fg_ftyp;  { wsprzdne uytkownika }
 PointVisible :Boolean;
 XYFuncNo : Integer;
 XYFunc :TUserFunc;
begin
if FRangeMaxX=FRangeMinX then
  begin
  ShowMessage('Bd TFuncGraph: RangeMaxX nie moe by rwny RangeMinX');
  Exit;
  end;
if FRangeMaxY=FRangeMinY then
  begin
  ShowMessage('Bd TFuncGraph: RangeMaxY nie moe by rwny RangeMinY');
  Exit;
  end;

 inherited Paint;
 with Canvas do
 	begin
    //Brzeg i tlo
 	Pen:=FBorderPen;
 	Brush:=FBackgroundBrush;
 	Rectangle(0,0,Width,Height);
    //Os zerowa
    if FXZeroAxis or FYZeroAxis then
    	begin
	    Pen:=FZeroAxisPen;
        if FXZeroAxis then
        	begin
            Y:=Round((1 - ((0-FRangeMinY)/(FRangeMaxY-FRangeMinY))) * Height); //1- bo odwrotnie wsp. Canvas i wykresu
	    	MoveTo(0,Y);
        	LineTo(Width,Y);
            end;
        if FYZeroAxis then
        	begin
            X:=Round( ((0-FRangeMinX)/(FRangeMaxX-FRangeMinX)) * Width);
	    	MoveTo(X,0);
        	LineTo(X,Height);
            end;
        end;
    end;


 for XYFuncNo :=1 to 2 do
 begin
	 case XYFuncNo of
	  1:
      	begin
      	Canvas.Pen:=FAddPlotPen;
        XYFunc := FAddUserFunc; //dodatkowa jako pierwsza, zeby byla z tylu na wykresie
        end;
	  2:
      	begin
        Canvas.Pen:=FPlotPen;
      	XYFunc := FUserFunc;
        end;
	 end;


 //Petla po X
 for X := 1 to Width do
 begin
  { konwersja wsprzdnej X }
  RX := FRangeMinX + (((FRangeMaxX - FRangeMinX)/Width)*X); //JM: RangeMaxX nie moze byc rowne RangeMinX
  PointVisible:=true; //zakladamy, ze widoczne

  { sprawdzamy, czy istnieje funkcja zdefiniowana przez uytkownika;
    jeli tak, to j wywoujemy }
  if Assigned(XYFunc) then
   XYFunc(RX,RY,PointVisible)
  else
   begin
   RY := 0;
   PointVisible:=false;
   end;

  { konwersja wsprzednej Y, operacja rysowania }
  Y := Round((1 - ((RY-FRangeMinY)/(FRangeMaxY-FRangeMinY))) * Height); //JM: RangeMaxY nie moze byc rowne RangeMinY
  if X = 1 then
   Canvas.MoveTo(X,Y)
  else
   if PointVisible then Canvas.LineTo(X,Y) else Canvas.MoveTo(X,Y);
 end;

end; //od petli po wykresach


end;


end.


