//---------------------------------------------------------------------------

#pragma hdrstop

#include<stdexcept> //wyjatki
#include<iostream> //strumienie (cout,cin)
#include<fstream> //strumienie (pliki)
using namespace std;

double rzut(int i,double* y,double t)
{
        static const double g=-9.81;

        double wynik=0;
        switch(i)
        {
                case 0:
                        wynik=y[1];
                        break;
                case 1:
                        wynik=g;
                        break;

                default:
                        throw runtime_error("Zly numer rownania");
        }

        return wynik;
}

/*
double* odeint_Euler(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
        for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
        return y_nast;
}
*/

template<typename T>
T* odeint_Euler(int N,T (*f)(int,T*,T),T* y,T t,T h,T* y_nast)
{
        for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
        return y_nast;
}

template<typename T>
T* odeint_MidPoint(int N,T (*f)(int,T*,T),T* y,T t,T h,T* y_nast) //RK2, ulepszony Euler
{
        T* y_tmp=new T[N];
        for(int i=0;i<N;++i)
        {
                T k1=h*f(i,y,t);
                y_tmp[i]=y[i]+0.5*k1;
        }
        for(int i=0;i<N;++i)
        {
                T k2=h*f(i,y_tmp,t+0.5*h);
                y_nast[i]=y[i]+k2;
        }
        delete [] y_tmp;
        return y_nast;
}

//---------------------------------------------------------------------------
#pragma argsused

int main(int argc, char* argv[])
{
        int N=2;

        double* y=new double[N];
        double* y_nast=new double[N];
        for(int i=0;i<N;++i)
        {
                y[i]=0;
                y_nast[i]=0;
        }
        double tmax=10;
        double h=0.01;

        ofstream plik_wy("wyniki.dat");
        plik_wy.precision(10);
        plik_wy.setf(ios::scientific);

        for(double t=0;t<tmax;t+=h)
        {
                //odeint_Euler<double>(N,rzut,y,t,h,y_nast);
                odeint_MidPoint<double>(N,rzut,y,t,h,y_nast);

                cout << "t=" << t << "\ty[0]=" << y[0] << "\ty[1]=" << y[1] << "\n";
                plik_wy << t;
                for(int i=0;i<N;++i) plik_wy << "\t" << y[i];
                plik_wy << "\n";

                //wersja brute force
                //for(int i=0;i<N;++i) y[i]=y_nast[i];

                //zamiana miejscami tablic (zonglowanie wskaznikami)
                double* y_tmp=y;
                y=y_nast;
                y_nast=y_tmp;
        }

        plik_wy.close();

        delete [] y;
        delete [] y_nast;

        cout << "\nOK.\n\n";

        return 0;
}
//---------------------------------------------------------------------------


