//---------------------------------------------------------------------------

#pragma hdrstop

#include<stdexcept> //wyjatki
#include<iostream> //strumienie (cout,cin)
#include<fstream> //strumienie (pliki)
using namespace std;

#include<math.h> //fabs

const double blad_min=1E-11;
const double blad_max=1E-10;

bool komunikatyNaEkranie = false; //wyswietlanie na ekranie zabiera wiecej czasu niz obliczenia

double rzut(int i,double* y,double t)
//rzut swobodny: y[0]=x, y[1]=v
{
        static const double g=-9.81;

        double wynik=0;
        switch(i)
        {
                case 0:
                        wynik=y[1];
                        break;
                case 1:
                        wynik=g;
                        break;

                default:
                        throw runtime_error("Zly numer rownania");
        }

        return wynik;
}

double oscylacje(int i,double* y,double t)
//sila harmoniczna: y[0]=x, y[1]=v
{
        static const double w=1;
        static const double b=0;

        double wynik=0;
        switch(i)
        {
                case 0:
                        wynik=y[1];
                        break;
                case 1:
                        wynik=-w*w*y[0]-2*b*y[1];
                        break;

                default:
                        throw runtime_error("Zly numer rownania");
        }

        return wynik;
}

/*
double* odeint_Euler(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
        for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
        return y_nast;
}
*/

template<typename T>
T* odeint_Euler(int N,T (*f)(int,T*,T),T* y,T t,T h,T* y_nast)
{
        for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
        return y_nast;
}

template<typename T>
T* odeint_MidPoint(int N,T (*f)(int,T*,T),T* y,T t,T h,T* y_nast) //RK2, ulepszony Euler
{
        T* y_tmp=new T[N];
        for(int i=0;i<N;++i)
        {
                T k1=h*f(i,y,t);
                y_tmp[i]=y[i]+0.5*k1;
        }
        for(int i=0;i<N;++i)
        {
                T k2=h*f(i,y_tmp,t+0.5*h);
                y_nast[i]=y[i]+k2;
        }
        delete [] y_tmp;
        return y_nast;
}

template<typename T>
T* odeint_RK4(int N,T (*f)(int,T*,T),T* y,T t,T h,T* y_nast)
{
        T* y_tmp=new T[N];
        T* k1=new T[N];
        T* k2=new T[N];
        T* k3=new T[N];
        T* k4=new T[N];
        for(int i=0;i<N;++i)
        {
                k1[i]=h*f(i,y,t);
                y_tmp[i]=y[i]+0.5*k1[i];
        }
        for(int i=0;i<N;++i)
        {
                k2[i]=h*f(i,y_tmp,t+0.5*h);
                y_nast[i]=y[i]+0.5*k2[i];
        }
        for(int i=0;i<N;++i)
        {
                k3[i]=h*f(i,y_nast,t+0.5*h);
                y_tmp[i]=y[i]+k3[i];
        }
        for(int i=0;i<N;++i)
        {
                k4[i]=h*f(i,y_tmp,t+h);
                y_nast[i]=y[i]+(k1[i]+2.0*k2[i]+2.0*k3[i]+k4[i])/6.0;
        }
        delete [] y_tmp;
        delete [] k1;
        delete [] k2;
        delete [] k3;
        delete [] k4;
        return y_nast;
}

template<typename T>
T* odeint_RKF45(int N,T (*f)(int,T*,T),T* y,T t,T& h,T* y_nast) //h - przez referencje
{
        static const T b31=3.0/32.0; static const T b32=9.0/32.0; static const T a3=3.0/8.0;
        static const T b41=1932.0/2197.0; static const T b42=-7200.0/2197.0; static const T b43=7296.0/2197.0; static const T a4=12.0/13.0;
        static const T b51=439.0/216.0; static const T b53=3680.0/513.0; static const T b54=-845.0/4104.0;
        static const T w41=25.0/216.0; static const T w43=1408.0/2565.0; static const T w44=2197.0/4104.0;

        static const T b61=-8.0/27.0; static const T b63=-3544.0/2565.0; static const T b64=1859.0/4104.0; static const T b65=-11.0/40.0;
        static const T w51=16.0/135.0; static const T w53=6656.0/12825.0; static const T w54=28561.0/56430.0; static const T w55=-9.0/50.0; static const T w56=2.0/55.0;

        T* y_tmp=new T[N];
        T* y4_nast=new T[N]; //y5_nast->y_nast
        T* k1=new T[N];
        T* k2=new T[N];
        T* k3=new T[N];
        T* k4=new T[N];
        T* k5=new T[N];
        T* k6=new T[N];

        T blad=0;
        do
        {
                for(int i=0;i<N;++i)
                {
                        k1[i]=h*f(i,y,t);
                        y_tmp[i]=y[i]+0.25*k1[i];
                }
                for(int i=0;i<N;++i)
                {
                        k2[i]=h*f(i,y_tmp,t+0.25*h);
                        y_nast[i]=y[i]+b31*k1[i]+b32*k2[i];
                }
                for(int i=0;i<N;++i)
                {
                        k3[i]=h*f(i,y_nast,t+a3*h);
                        y_tmp[i]=y[i]+b41*k1[i]+b42*k2[i]+b43*k3[i];
                }
                for(int i=0;i<N;++i)
                {
                        k4[i]=h*f(i,y_tmp,t+a4*h);
                        y_nast[i]=y[i]+b51*k1[i]-8.0*k2[i]+b53*k3[i]+b54*k4[i];
                }
                for(int i=0;i<N;++i)
                {
                        k5[i]=h*f(i,y_nast,t+h);
                        y4_nast[i]=y[i]+w41*k1[i]+w43*k3[i]+w44*k4[i]-0.2*k5[i]; //RK4 (5 wyrazow)
                        y_tmp[i]=y[i]+b61*k1[i]+2*k2[i]+b63*k3[i]+b64*k4[i]+b65*k5[i];
                }
                blad=0;
                for(int i=0;i<N;++i)
                {
                        k6[i]=h*f(i,y_tmp,t+0.5*h);
                        y_nast[i]=y[i]+w51*k1[i]+w53*k3[i]+w54*k4[i]+w55*k5[i]+w56*k6[i]; //RK5 (6 wyrazow)
                        blad+=fabs(y_nast[i]-y4_nast[i]);
                }

                if(komunikatyNaEkranie) cout << "RKF4(5) -- blad: " << blad << ", krok=" << h << "\n";
                if(blad<blad_min) h*=2;
                if(blad>blad_max) h/=2;
                if(komunikatyNaEkranie) cout << "RKF4(5) -- nowy krok=" << h << "\n";
        }
        while(blad<blad_min || blad>blad_max);

        delete [] y_tmp;
        delete [] y4_nast;
        delete [] k1;
        delete [] k2;
        delete [] k3;
        delete [] k4;
        delete [] k5;
        delete [] k6;

        return y_nast;
}

enum Algorytm {AlgorytmEulera,AlgorytmRK2,AlgorytmMidPoint,AlgorytmRK4,AlgorytmRKF45};

template<typename T>
T* odeint(Algorytm algorytm,int n,T (*f)(int i,T* y,T t),T* y,T t,T& h,T* y_nast)
{
        T* wynik=NULL;

        switch(algorytm)
        {
                case AlgorytmEulera:
                        wynik=odeint_Euler<T>(n,f,y,t,h,y_nast);
                        break;
                case AlgorytmRK2:
                case AlgorytmMidPoint:
                        wynik=odeint_MidPoint<T>(n,f,y,t,h,y_nast);
                        break;
                case AlgorytmRK4:
                        wynik=odeint_RK4<T>(n,f,y,t,h,y_nast);
                        break;
                case AlgorytmRKF45:
                        wynik=odeint_RKF45<T>(n,f,y,t,h,y_nast);
                        break;

                default:
                        throw runtime_error("Nierozpoznany algorytm");
    }
    return wynik;
}

//---------------------------------------------------------------------------
#pragma argsused

int main(int argc, char* argv[])
{
        int N=2;

        double* y=new double[N];
        double* y_nast=new double[N];
        for(int i=0;i<N;++i)
        {
                y[i]=0;
                y_nast[i]=0;
        }
        y[0]=1; //do oscylatora

        double tmax=100;
        double h=0.1;

        ofstream plik_wy("wyniki.dat");
        plik_wy.precision(10);
        plik_wy.setf(ios::scientific);

        for(double t=0;t<tmax;t+=h)
        {
                //odeint_Euler<double>(N,rzut,y,t,h,y_nast);
                //odeint_MidPoint<double>(N,rzut,y,t,h,y_nast);

                //odeint_Euler<double>(N,oscylacje,y,t,h,y_nast);
                //odeint_MidPoint<double>(N,oscylacje,y,t,h,y_nast);
                //odeint_RK4<double>(N,oscylacje,y,t,h,y_nast);
                //odeint_RKF45<double>(N,oscylacje,y,t,h,y_nast);

                odeint<double>(AlgorytmRKF45,N,oscylacje,y,t,h,y_nast);

                if(komunikatyNaEkranie) cout << "t=" << t << "\ty[0]=" << y[0] << "\ty[1]=" << y[1] << "\n";
                plik_wy << t;
                for(int i=0;i<N;++i) plik_wy << "\t" << y[i];
                plik_wy << "\t" << h;
                plik_wy << "\n";

                //wersja brute force
                //for(int i=0;i<N;++i) y[i]=y_nast[i];

                //zamiana miejscami tablic (zonglowanie wskaznikami)
                double* y_tmp=y;
                y=y_nast;
                y_nast=y_tmp;
        }

        plik_wy.close();

        delete [] y;
        delete [] y_nast;

        cout << "\nOK.\n\n";

        return 0;
}
//---------------------------------------------------------------------------


