﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;

using PDE;
using System.IO;

namespace pde
{
    class Program
    {
        #region Test metod rozwiązywania układu równań z macierzą trójprzekątniową
        static void test_rozw3p()
        {
            const int N = 3;
            Complex[] A = new Complex[N];
            Complex[] B = new Complex[N];
            Complex[] C = new Complex[N];
            Complex[] D = new Complex[N];
            Complex[] f = new Complex[N];


            B[0] = 1; A[0] = 2; D[0] = 1;
            C[1] = 1; B[1] = 2; A[1] = 3; D[1] = 2;
            C[2] = 2; B[2] = 2; D[2] = 1;

            try
            {
                PDE.UkladTrojprzekatniowy.rozw3p(N, A, B, C, D, f);
            }
            catch (Exception exc)
            {
                Console.Error.WriteLine("*** Blad: " + exc.Message);
            }

            Console.Out.Write("f: ");
            for (int i = 0; i < N; i++) Console.Out.Write(f[i].ToString() + "; ");
            Console.Out.WriteLine();

            //prawidlowe wyniki: f[0]=2/3, f[1]=1/6, f[2]=1/3
        }
        #endregion

        //---------------------------------------------------------------------------

        #region TDSE
        //siec x
        const int Nx = 1001;
        const double xmin = -10;
        const double xmax = 10;
        const double dx = (xmax - xmin) / (Nx - 1);
        static double x(int i)
        {
            return xmin + i * dx;
        }

        //siec t
        const int Nt = 1000;
        const double dt = 0.01;
        static double t(int k)
        {
            return k * dt;
        }

        //funkcja poczatkowa (nieunormowana)
        static Complex gauss(double x)
        {
            const double a = 1; //szerokosc
            const double x0 = -5;
            const double k = 0; //wektor falowy, ped (p=hk)
            double _x = (x - x0) / (2 * a);
            return Complex.Exp(-_x * _x + Complex.I * k * x);
        }

        static Complex V(double x)
        {
            //return 0; //brak potencjalu
            //return (x<0)?0:1; //prog potencjalu
            return 0.5 * x * x; //oscylator harmoniczny            
        }

        const double h = 1;
        const double m = 1;
        static Complex S2 = -h * h / (2 * m) / (Complex.I * h);
        static Complex S0(double x)
        {
            return V(x) / (Complex.I * h);
        }

        static void tdse(bool komunikatyNaEkranie)
        {
            Console.Out.WriteLine("Nx=" + Nx + ", dx=" + dx + ", x(" + xmin + "," + xmax + ")");
            Console.Out.WriteLine("Nt=" + Nt + ", dt=" + dt);

            Complex[] A = new Complex[Nx];
            Complex[] B = new Complex[Nx];
            Complex[] C = new Complex[Nx];
            Complex[] D = new Complex[Nx];
            Complex[] Psi = new Complex[Nx];

            //ustalanie i normowanie poczatkowej funkcji falowej
            double norma = 0;
            for (int i = 0; i < Nx; i++)
            {
                Psi[i] = gauss(x(i));
                norma += Psi[i].Norm;
            }
            norma *= dx;
            norma = Math.Sqrt(norma);
            for (int i = 0; i < Nx; i++) Psi[i] /= norma;
            
            StreamWriter plik_wy_obs = new StreamWriter("obserwable.dat");

            //ewolucja funkcji falowej
            for (int k = 0; k <= Nt; k++)
            {
                if (k > 0)
                {
                    //obliczanie wyrazow macierzy do diagonalizacji
                    for (int i = 0; i < Nx; i++)
                    {
                        A[i] = -S2 / dx;
                        B[i] = 2 * dx / dt + 2 * S2 / dx - dx * S0(x(i));
                        C[i] = -S2 / dx;
                        D[i] = Psi[i] * (2 * dx / dt - 2 * S2 / dx + dx * S0(x(i)));
                        //warunki brzegowe (funkcja znika na brzegach)
                        if (i < Nx - 1) D[i] += Psi[i + 1] * (S2 / dx);
                        if (i > 0) D[i] += Psi[i - 1] * (S2 / dx);
                    }


                    //warunki brzegowe (funkcja znika na brzegach)
                    A[Nx - 1] = 0;
                    C[0] = 0;

                    //rozwiazywanie ukladu rownan
                    try
                    {
                        PDE.UkladTrojprzekatniowy.rozw3p(Nx, A, B, C, D, Psi);
                    }
                    catch (Exception exc)
                    {
                        Console.Error.WriteLine("*** Blad: " + exc.Message);
                        System.Environment.Exit(1);
                    }
                }

                //obliczanie zaleznych od czasu wartosci oczekiwanych
                norma = 0;
                double polozenie = 0;
                Complex ped = 0;
                for (int i = 0; i < Nx; i++)
                {
                    norma += Psi[i].Norm;
                    polozenie += x(i) * Psi[i].Norm;
                    if (i > 0 && i < Nx - 1)
                        ped += Complex.Conj(Psi[i]) * (Psi[i + 1] - Psi[i - 1]);
                }
                norma *= dx;
                //for (int i = 0; i < Nx; i++) Psi[i] /= Math.Sqrt(norma); //renormalizacja
                polozenie *= dx;
                ped *= -Complex.I * h * dx / (2 * dx); //dx sie skraca

                double wariancja = 0;
                for (int i = 0; i < Nx; ++i)
                {
                    wariancja += (x(i) - polozenie) * (x(i) - polozenie) * Psi[i].Norm;
                }
                wariancja *= dx;
                wariancja = Math.Sqrt(wariancja);

                if (komunikatyNaEkranie) Console.Out.WriteLine("Norma=" + norma + "  <x>=" + polozenie + "\t<p>=" + ped + "\tD(x)=" + wariancja);
                plik_wy_obs.WriteLine(t(k) + "\t" + norma + "\t" + polozenie + "\t" + ped.Real + "\t" + ped.Imag + "\t" + wariancja);
            }

            plik_wy_obs.Close();
        }
        #endregion

        static void Main(string[] args)
        {
            //test_rozw3p();
            tdse(true);

            Console.Out.WriteLine();
            Console.Out.WriteLine("OK.");
            Console.Out.WriteLine();
        }
    }
}
