// Piatek1.cpp : Defines the entry point for the console application.
//

#include "stdafx.h"

#include <stdexcept>
#include <iostream>
#include <fstream>
using namespace std;

//fizyka
double rzut(int i,double* y,double t) //1D
{
	static const double g=9.81;

	double wynik=0;
	switch(i)
	{
	case 0:
		wynik=y[1];
		break;
	case 1:
		wynik=g;
		break;
	default:
		throw runtime_error("Zy numer rwnania");
	}

	return wynik;
}

//numeryka
double* odeint_Euler(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
	return y_nast;
}


double* odeint_MidPoint(int N,double (*f)(int,double*,double),double* y,double t,double h,double* y_nast)
{
	double* y_tmp=new double[N];	
	for(int i=0;i<N;++i)
	{
		double k1=h*f(i,y,t);
		y_tmp[i]=y[i]+0.5*k1;
	}
	for(int i=0;i<N;++i)
	{
		double k2=h*f(i,y_tmp,t+0.5*h);
		y_nast[i]=y[i]+k2;
	}
	delete [] y_tmp;
	return y_nast;
}

/*
template<typename T>
T* odeint_Euler(int N,T (*f)(int,T*,T),T* y,T t,T h,T* y_nast)
{
	for(int i=0;i<N;++i) y_nast[i]=y[i]+h*f(i,y,t);
	return y_nast;
}
*/

int _tmain(int argc, _TCHAR* argv[])
{
	const int N=2; //1D
	double* y=new double[N];
	double* y_nast=new double[N];
	for(int i=0;i<N;++i)
	{
		y[i]=0;
		y_nast[i]=0;
	}
	const double tmax=10;
	const double h=0.1;

	ofstream plik_wy("wyniki.dat");
	plik_wy.precision(10);
	plik_wy.setf(ios::scientific);

	for(double t=0;t<tmax;t+=h)
	{
#ifdef _DEBUG
		cout << "t=" << t << ", x=" << y[0] << ", v=" << y[1] << "\n";
#endif
		plik_wy << t << "\t" << y[0] << "\t" << y[1] << "\n";

		//odeint_Euler(N,rzut,y,t,h,y_nast);
		odeint_MidPoint(N,rzut,y,t,h,y_nast);		

		//brzydkie
		//for(int i=0;i<N;++i) y[i]=y_nast[i];
		
		double* y_tmp=y_nast;
		y_nast=y;
		y=y_tmp;

		//swap(y,y_nast);
	}

	plik_wy.close();

	delete [] y_nast;
	delete [] y;

	cout << "OK.\n\n";

	return 0;
}

