#include <stdexcept> //wyjtki
#include <iostream> //cout
#include <fstream> //pliki
using namespace std;

const int N = 14;

//problem fizyczny
template<typename T>
T rzut(int i, T* y, T t) //1D,n=2 -> N=2
{
	static const double g = 9.81; // => SI

	double wynik = 0;
	switch (i)
	{
	case 0:
		wynik = y[1];
		break;
	case 1:
		wynik = g;
		break;

	default:
		throw runtime_error("Zy numer rwnania");
	}

	return wynik;
}

template<typename T>
T oscylacje(int i, T* y, T t) //1D,n=2 -> N=2
{
	static const double w = 1;
	static const double b = 0;

	double wynik = 0;
	switch (i)
	{
	case 0:
		wynik = y[1];
		break;
	case 1:
		wynik = -w*w*y[0] - 2 * b*y[1];
		break;

	default:
		throw runtime_error("Zy numer rwnania");
	}
	return wynik;
}

template<typename T>
T oscylacje_sprzezone(int i, T* y, T t) //n w 1D -> N = 2n
{
	static const double w = 1;
	static const double b = 0;

	double wynik = 0;
	if (i % 2 == 0)
	{
		//polozenia
		wynik = y[i + 1];		
	}
	else
	{
		//predkosci
		//wynik = -w*w*y[i - 1] - 2 * b*y[i];
		//*
		wynik = -2 * b*y[i];
		if (i > 1) wynik += -w*w*(y[i - 1] - y[i - 3] - 1);
		if (i < N - 1) wynik += +w*w*(y[i + 1] - y[i - 1] - 1);
		//*/
	}

	return wynik;
}


//solver - Euler
template<typename T>
T* odeint_Euler(int N, T(*f)(int, T*, T), T* y, T t, T h, T* y_nast)
{
	for (int i = 0; i < N; ++i) y_nast[i] = y[i] + h* f(i, y, t);	
	return y_nast;
}

//solver - MidPoint
template<typename T>
T* odeint_MidPoint(int N, T(*f)(int, T*, T), T* y, T t, T h, T* y_nast)
{
	T* y_tmp = new T[N];
	for (int i = 0; i < N; ++i)
	{
		T k1 = h*f(i, y, t);
		y_tmp[i] = y[i] + 0.5*k1;
	}
	for (int i = 0; i < N; ++i)
	{
		T k2 = h * f(i, y_tmp, t + 0.5*h);
		y_nast[i] = y[i] + k2;
	}
	return y_nast;
}

template<typename T>
T* odeint_RK4(int N, T(*f)(int, T*, T), T* y, T t, T h, T* y_nast)
{
	T* y_tmp = new T[N];
	T* k1 = new T[N];
	T* k2 = new T[N];
	T* k3 = new T[N];
	T* k4 = new T[N];
	for (int i = 0; i < N; ++i)
	{
		k1[i] = h*f(i, y, t);
		y_tmp[i] = y[i] + 0.5*k1[i];
	}
	for (int i = 0; i < N; ++i)
	{
		k2[i] = h*f(i, y_tmp, t + 0.5*h);
		y_nast[i] = y[i] + 0.5*k2[i];
	}
	for (int i = 0; i < N; ++i)
	{
		k3[i] = h*f(i, y_nast, t + 0.5*h);
		y_tmp[i] = y[i] + k3[i];
	}
	for (int i = 0; i < N; ++i)
	{
		k4[i] = h* f(i, y_tmp, t + h);
		y_nast[i] = y[i] + (k1[i] + 2.0*k2[i] + 2.0*k3[i] + k4[i]) / 6.0;
	}
	delete[] k1;
	delete[] k2;
	delete[] k3;
	delete[] k4;
	delete[] y_tmp;

	return y_nast;
}

int main()
{
	//cout << "Hello, Physics!\n";

	//int N = 2;

	double* y = new double[N];
	double* y_nast = new double[N];
	for (int i = 0; i < N; ++i)
	{
		y[i] = 0; //m
		y_nast[i] = 0;
	}
	double tmax = 100; //s
	double h = 0.01; //s

	for (int i = 0; i < N; i += 2)
	{
		y[i] = i / 2;
	}
	y[1] = 1;
	y[N-1] = -1;
	
	//y[1] = 1;

	//plik
	ofstream plik_wy("wyniki.dat");
	plik_wy.precision(10);
	plik_wy.setf(ios::scientific);

	//ewolucja ukadu
	for (double t = 0; t < tmax; t += h)
	{
		//odeint_Euler<double>(N, rzut<double>, y, t, h, y_nast);
		//odeint_MidPoint<double>(N, rzut<double>, y, t, h, y_nast);
		//odeint_Euler<double>(N, oscylacje<double>, y, t, h, y_nast);
		//odeint_MidPoint<double>(N, oscylacje<double>, y, t, h, y_nast);
		//odeint_RK4<double>(N, oscylacje<double>, y, t, h, y_nast);
		//odeint_Euler<double>(N, oscylacje_sprzezone<double>, y, t, h, y_nast);
		//odeint_MidPoint<double>(N, oscylacje_sprzezone<double>, y, t, h, y_nast);
		odeint_RK4<double>(N, oscylacje_sprzezone<double>, y, t, h, y_nast);

		//cout << "t=" << t << "\ty[0]=" << y[0] << "\ty[1]=" << y[1] << "\n";
		plik_wy << t;
		for (int i = 0; i < N; ++i) plik_wy << "\t" << y[i];
		plik_wy << "\n";

		//brute-force
		/*
		for (int i = 0; i < N; ++i)
		{
			y[i] = y_nast[i];
			y_nast[i] = 0; //niepotrzebne			
		}
		*/

		double* y_tmp = y;
		y = y_nast;
		y_nast = y_tmp;
	}

	plik_wy.close();

	cout << "\n\nOK.\n";

	delete[] y;
}