#pragma once

#ifndef __gx_mesh_h__
	#define __gx_mesh_h__

#include "foundation.h"
#include "graphicsresource.h"
#include "gxopengl.h"

namespace Gx
{
	class IndexBuffer;
	class VertexBuffer;

	class GX_API Mesh : public GraphicsResource
	{
	public:
		Mesh();
		virtual ~Mesh();

		void setPrimitiveType(GLenum primitiveType);

		void setIndexBuffer(IndexBuffer* indexBuffer);
		void setVertexBuffer(VertexBuffer* vertexBuffer);

		IndexBuffer* getIndexBuffer() const {
			return m_indexBuffer;
		}

		VertexBuffer* getVertexBuffer() const {
			return m_vertexBuffer;
		}

		void setIndexBufferRange(GxU32 firstIndex, GxU32 indexCount);
		void setVertexBufferRange(GxU32 firstVertex, GxU32 vertexCount);

		void bind();
		void render();
		void unbind();

	private:
		GLuint m_vertexArray;
		GLenum m_primitiveType;

		IndexBuffer* m_indexBuffer;
		GxU32 m_firstIndex;
		GxU32 m_indexCount;

		VertexBuffer* m_vertexBuffer;
		GxU32 m_firstVertex;
		GxU32 m_vertexCount;
	};
}

#endif /* __gx_mesh_h__ */