//solver
template<typename T>
T* odeint_Euler(int N, T(*f)(int, T*, T), T* y, T t, T h, /*out*/T* y_nast)
{
	for (int i = 0; i < N; ++i) y_nast[i] = y[i] + h*f(i, y, t);
	return y_nast;
}

template<typename T>
T* odeint_MidPoint(int N, T(*f)(int, T*, T), T* y, T t, T h, /*out*/T* y_nast)
//MidPoint = RK2
{
	T* y_tmp = new T[N];

	for (int i = 0; i < N; ++i)
	{
		T k1 = h*f(i, y, t);
		y_tmp[i] = y[i] + 0.5*k1;
	}
	for (int i = 0; i < N; ++i)
	{
		T k2 = h*f(i, y_tmp, t + 0.5*h);
		y_nast[i] = y[i] + k2;
	}

	delete[] y_tmp;
	return y_nast;
}

template<typename T>
T* odeint_RK4(int N, T(*f)(int, T*, T), T* y, T t, T h, /*out*/T* y_nast)
{
	T* y_tmp = new T[N];
	T* k1 = new T[N];
	T* k2 = new T[N];
	T* k3 = new T[N];
	T* k4 = new T[N];
	for (int i = 0; i < N; ++i)
	{
		k1[i] = h*f(i, y, t);
		y_tmp[i] = y[i] + 0.5*k1[i];
	}
	for (int i = 0; i < N; ++i)
	{
		k2[i] = h*f(i, y_tmp, t + 0.5*h);
		y_nast[i] = y[i] + 0.5*k2[i];
	}
	for (int i = 0; i < N; ++i)
	{
		k3[i] = h*f(i, y_nast, t + 0.5*h);
		y_tmp[i] = y[i] + k3[i];
	}
	for (int i = 0; i < N; ++i)
	{
		k4[i] = h*f(i, y_tmp, t + h);
		y_nast[i] = y[i] + (k1[i] + 2.0*k2[i] + 2.0*k3[i] + k4[i]) / 6.0;
	}
	delete[] y_tmp;
	delete[] k1;
	delete[] k2;
	delete[] k3;
	delete[] k4;
	return y_nast;
}
