// Euler_Verlet.cpp : Defines the entry point for the console application.
//

//#include "stdafx.h"
#include <stdexcept>
#include <iostream>
#include <fstream>
using namespace std;

const int N = 2;

//funkcja, ktra oblicza przyspieszenie
double rzut(int i, double* y, double t)
{
	static const double g = 9.81; //m i s

	double wynik = 0;
	switch(i)
	{
	case 0:
		wynik = y[1];		
		break;
	case 1:
		wynik = g;
		break;

	default:
		throw runtime_error("Zy numer rwnania");
	}

	return wynik;
}

double oscylator(int i, double* y, double t)
{
	static const double k = 1;

	double wynik = 0;
	switch (i)
	{
	case 0:
		wynik = y[1];
		break;
	case 1:
		wynik = -k*y[0];
		break;

	default:
		throw runtime_error("Zy numer rwnania");
	}

	return wynik;
}


double* odeint_Euler(int N, double(*f)(int i, double* y, double t), double* y, double t, double h, double* y_nast)
{
	for (int i = 0; i < N; i++) y_nast[i] = y[i] + h*f(i, y, t);
	return y_nast;
}

double* odeint_MidPoint(int N, double(*f)(int i, double* y, double t), double* y, double t, double h, double* y_nast)
{
	double* y_tmp = new double[N];
	double k1, k2;

	for (int i = 0; i < N; ++i)
	{
		k1 = h*f(i, y, t);
		y_tmp[i] = y[i] + 0.5*k1;
	}

	for (int i = 0; i < N; ++i)
	{
		k2 = h*f(i, y_tmp, t + 0.5*h);
		y_nast[i] = y[i] + k2;
	}

	delete[] y_tmp;

	return y_nast;
}


/*
int _tmain(int argc, _TCHAR* argv[])
{
	return 0;
}
*/

int main(int argc, char* argv)
{
	double* y = new double[N];
	double* y_nast = new double[N];

	for (int i = 0; i < N; ++i) y[i] = 0;

	y[0] = 1;

	const double h = 0.01;
	const double tmax = 100;

	ofstream plik_wy("..\\Debug\\wyniki.dat");	

	for (double t = 0; t < tmax; t += h)
	{
		//odeint_Euler(N, rzut, y, t, h, y_nast);
		//odeint_Euler(N, oscylator, y, t, h, y_nast);
		odeint_MidPoint(N, oscylator, y, t, h, y_nast);

		//cout << t << "\t";
		plik_wy << t << "\t";
		for (int i = 0; i < N; ++i)
		{
			y[i] = y_nast[i];
			//cout << y[i] << "\t";
			plik_wy << y[i] << "\t";
		}
		//cout << "\n";
		plik_wy << "\n";
	}

	plik_wy.close();

	delete[] y;
	delete[] y_nast;

	cout << "OK.\n\n";

	return 0;
}
