#include "PunktMaterialny.h"

void PunktMaterialny::_PunktMaterialny(double pooenie, double prdko, double masa)	
{
	numerKroku = 0;
	this->pooenie = pooenie;
	this->poprzedniePooenie = pooenie;
	this->prdko = prdko;
	this->masa = masa;
}

PunktMaterialny::PunktMaterialny(double pooenie, double prdko, double masa)
{
	_PunktMaterialny(pooenie, prdko, masa);
}

PunktMaterialny::PunktMaterialny()
{
	_PunktMaterialny(0, 0, 1);
}

double PunktMaterialny::Pooenie() const
{
	return pooenie;
}

double PunktMaterialny::PoprzedniePooenie() const
{
	return poprzedniePooenie;
}

double PunktMaterialny::NastpnePooenie() const
{
	return nastpnePooenie;
}

double PunktMaterialny::Prdko() const
{
	return prdko;
}

double PunktMaterialny::Masa() const
{
	return masa;
}

void PunktMaterialny::UstawPooenie(double pooenie)
{
	this->pooenie = pooenie;
	UstawPoprzedniePooenie(pooenie);
}

void PunktMaterialny::UstawPoprzedniePooenie(double poprzedniePooenie)
{
	this->poprzedniePooenie = pooenie;
}

void PunktMaterialny::UstawPrdko(double prdko)
{
	this->prdko = prdko;
}

void PunktMaterialny::UstawMas(double masa)
{
	this->masa = masa;
}

int PunktMaterialny::NumerKroku()
{
	return numerKroku;
}

void PunktMaterialny::PrzygotujRuch_Euler(double przyspieszenie, double krokCzasowy)
{
	nastpnaPrdko = prdko + przyspieszenie * krokCzasowy;
	nastpnePooenie = pooenie + prdko * krokCzasowy;
}

void PunktMaterialny::PrzygotujRuch_EulerPoprawiony(double przyspieszenie, double krokCzasowy)
{
	nastpnaPrdko = prdko + przyspieszenie * krokCzasowy;
	nastpnePooenie = pooenie + nastpnaPrdko * krokCzasowy;
}

void PunktMaterialny::PrzygotujRuch_Verlet(double przyspieszenie, double krokCzasowy)
{
	nastpnePooenie = -poprzedniePooenie + 2 * pooenie + przyspieszenie*krokCzasowy*krokCzasowy;
	nastpnaPrdko = (nastpnePooenie - poprzedniePooenie) / (2 * krokCzasowy); //oszustwo
}

void PunktMaterialny::PrzygotujRuch(double sia, double krokCzasowy, Algorytm algorytm)
{
	double przyspieszenie = sia / masa;
	switch (algorytm)
	{
	case algorytmEulera:
		PrzygotujRuch_Euler(przyspieszenie, krokCzasowy);
		break;
	case algorytmEuleraPoprawiony:
		PrzygotujRuch_EulerPoprawiony(przyspieszenie, krokCzasowy);
		break;
	case algorytmVerleta:
		PrzygotujRuch_Verlet(przyspieszenie, krokCzasowy);
		break;
	}
}

void PunktMaterialny::WykonajRuch()
{
	poprzedniePooenie = pooenie;
	pooenie = nastpnePooenie;
	prdko = nastpnaPrdko;
	++numerKroku;
}