#include "PunktMaterialny.h"
#include <iostream>
#include <stdexcept>

class SpadekSwobodny : public ZbirPunktwMaterialnych
{
private:
	double g;

public:
	SpadekSwobodny()
		:ZbirPunktwMaterialnych(1),
		g(9.81)
	{
		PunktMaterialny* p = PobierzPunktMaterialny(0);
		p->UstawPooenie(0);
		p->UstawPrdko(0);
		p->UstawMas(1);
	}

protected:
	double Sia(int indeks) const
	{
		if (indeks != 0) std::runtime_error("Niepoprawny indeks punktu materialnego");
		return -g*PobierzPunktMaterialny(0)->Masa();
		//return -g*punkty[0].Masa();
	}
};

class Oscylator : public ZbirPunktwMaterialnych
{
private:
	double k;
public:
	Oscylator(double k)
		:ZbirPunktwMaterialnych(1),
		k(k)
	{
		PunktMaterialny* p = PobierzPunktMaterialny(0);
		p->UstawPooenie(1);
		p->UstawPrdko(0);
		p->UstawMas(1);
	}

protected:
	double Sia(int indeks) const
	{
		if (indeks != 0) std::runtime_error("Niepoprawny indeks punktu materialnego");
		return -k*PobierzPunktMaterialny(0)->Pooenie();
	}
};

class OscylatorySprzone : public ZbirPunktwMaterialnych
{
	//TODO
};

int main(int argc, char* argv[])
{
	//ZbirPunktwMaterialnych* zpm = new SpadekSwobodny();
	ZbirPunktwMaterialnych* zpm = new Oscylator(1);

	double h = 0.01;
	for (double t = 0; t < 1000; t += h)
	{
		zpm->KrokNaprzd(h, algorytmVerleta);
		std::cout <<
			t << "  " <<
			zpm->PobierzPunktMaterialny(0)->Pooenie() << "  " <<
			zpm->PobierzPunktMaterialny(0)->Prdko() << "\n";
	}

	return 0;
}

