#pragma once

enum Algorytm { algorytmEulera, algorytmEuleraPoprawiony, algorytmVerleta };

class PunktMaterialny
{
private:
	double poprzedniePooenie;
	double pooenie;
	double prdko;
	double nastpnePooenie;
	double nastpnaPrdko;
	double masa;
	void PunktMaterialny::_PunktMaterialny(double pooenie, double prdko, double masa);
	bool czyPierwszyKrok;

public:
	PunktMaterialny(double pooenie, double prdko, double masa);
	PunktMaterialny(void);

	double Pooenie() const;
	double PoprzedniePooenie() const;
	double NastpnePooenie() const;
	double Prdko() const;
	double Masa() const;

	void UstawPooenie(double pooenie);
	void UstawPoprzedniePooenie(double poprzedniePooenie);
	void UstawPrdko(double prdko);
	void UstawMas(double masa);

private:
	int numerKroku;
	void PrzygotujRuch_Euler(double przyspieszenie, double krokCzasowy);
	void PrzygotujRuch_EulerPoprawiony(double przyspieszenie, double krokCzasowy);
	void PrzygotujRuch_Verlet(double przyspieszenie, double krokCzasowy);

public:
	void PrzygotujRuch(double sia, double krokCzasowy, Algorytm algorytm);
	void WykonajRuch();
	int NumerKroku();
};

class ZbirPunktwMaterialnych //meneder
{
protected:
	int liczba;
	PunktMaterialny* punkty;	

	virtual double Sia(int indeks) const = 0;
	virtual void PrzedKrokiemNaprzd(double krokCzasowy){};
	virtual void PoPrzygotowaniuRuchu(double krokCzasowy){};
	virtual void PoKrokuNaprzd(double krokCzasowy){};

	virtual void PrzygotujRuch(double krokCzasowy, Algorytm algorytm);
	void WykonajRuch();	

public:
	ZbirPunktwMaterialnych(int liczba);
	virtual ~ZbirPunktwMaterialnych();
	void KrokNaprzd(double krokCzasowy, Algorytm algorytm);
	PunktMaterialny* PobierzPunktMaterialny(int indeks) const;

protected:		
	double rodekMasy();
	double redniaPrdko();
	void ZerujPrdkoredni();	
};

