﻿using System;
using Microsoft.VisualStudio.TestTools.UnitTesting;

using PDE;
using System.Numerics;

namespace Testowanie_3p
{
    
    [TestClass]
    public class UnitTest1
    {
        private const double epsilon = 1E-5;

        [TestMethod]
        public void TestMetody3p()
        {
            Complex[] A = new Complex[] { 2, 3, 0 };
            Complex[] B = new Complex[] { 1, 2, 2 };
            Complex[] C = new Complex[] { 0, 1, 2 };
            Complex[] D = new Complex[] { 1, 2, 1 };
            Complex[] f = new Complex[3];

            int wartość = PDE.UkladTrojprzekatniowy.rozw3p(3, A, B, C, D, f);

            Assert.AreEqual(0, wartość);
            Assert.AreEqual(2.0 / 3.0, f[0].Real, epsilon);
            Assert.AreEqual(1.0 / 6.0, f[1].Real, epsilon);
            Assert.AreEqual(1.0 / 3.0, f[2].Real, epsilon);
            Assert.AreEqual(0, f[0].Imaginary, epsilon);
            Assert.AreEqual(0, f[1].Imaginary, epsilon);
            Assert.AreEqual(0, f[2].Imaginary, epsilon);
        }
    }
}
