﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;



namespace dyfuzja3
{
    public partial class Form1 : Form
    {
        static int x = 300;
        static int y = 100;
        static int steps = 100;

        double dx = Convert.ToDouble(x / steps);
        double dy = Convert.ToDouble(x / steps);
        double dt = 0.01;

        public void gradient(double[][][] grad, double[][] xc)
        {
            for (int i = 1; i < x - 1; i++)
                for (int j = 1; j < y - 1; j++)
                {
                    grad[0][i][j] = (xc[i + 1][j] - xc[i - 1][j]) / (2 * dx); //gradient w kierunku x
                    grad[1][i][j] = (xc[i][j + 1] - xc[i][j - 1]) / (2 * dy); //gradient w kierunku y
                }
        }

        private void button1_Click(object sender, EventArgs e)
        {
            Graphics rectangle = CreateGraphics();
            Pen pen = new Pen(Color.White);
            Color kolor = new Color();

            int steps = 100;
            int Cp1 = Convert.ToInt32(textBox2.Text);
            int V = Convert.ToInt32(textBox1.Text);
            int Cp2 = 0;


            if (Cp1 > 100 || Cp1 < 0) { MessageBox.Show("Stężenie nie może być większe niż 100% oraz mniejsze niż 0%", "Złe stężenie"); this.Close(); }

            else if (V >= x * y) { MessageBox.Show("Objętość nie może być większa od objętości naczynia", "Zła objętość"); this.Close(); }

            else
            {
                Console.WriteLine("x = " + x);
                Console.WriteLine("y = " + y);
                Console.WriteLine("V = " + V);

               
                int x1 = Convert.ToInt32(V / y);
                int x2 = Convert.ToInt32(x - x1);

                Console.WriteLine("x1 = " + x1);
                Console.WriteLine("x2 = " + x2);

                double[][][] grad = new double[2][][];
                double[][] rozxx = new double[x][];
                double[][] rozxy = new double[x][];
                double[][] rozyy = new double[x][];
                double[][] xc = new double[x][];
                double[][] D = new double[2][];

                double vx = 0.106, vy = 0.106;

                D[0] = new double[2];
                D[1] = new double[2];
                D[0][0] = D[1][1] = 0.425;
                D[0][1] = D[1][0] = 0;

                for (int i = 0; i < x; i++)
                {
                    xc[i] = new double[y];
                    rozxx[i] = new double[y];
                    rozxy[i] = new double[y];
                    rozyy[i] = new double[y];
                }

                for (int i = 0; i < 2; i++)
                    grad[i] = new double[x][];

                for (int i = 0; i < x; i++)
                {
                    grad[0][i] = new double[y];
                    grad[1][i] = new double[y];
                }

                for (int i = 0; i < x1; i++)
                    for (int j = 0; j < y; j++)
                        xc[i][j] = Cp1/100.0;

                for (int i = x1; i < x; i++)
                    for (int j = 0; j < y; j++)
                        xc[i][j] = Cp2/100.0;

                for (int t = 0; t < steps; t++)
                {
                    gradient(grad, xc);

                    for (int i = 1; i < x - 1; i++)
                        for (int j = 1; j < y - 1; j++)
                        {
                            rozxx[i][j] = (xc[i - 1][j] - 2 * xc[i][j] + xc[i + 1][j]) / (dx * dx);
                            rozxy[i][j] = (xc[i + 1][j + 1] - xc[i + 1][j - 1] - xc[i - 1][j + 1] + xc[i - 1][j - 1]) / (4 * dx * dy);
                            rozyy[i][j] = (xc[i][j - 1] - 2 * xc[i][j] + xc[i][j + 1]) / (dy * dy);
                        }

                    for (int i = 0; i < x; i++)
                        for (int j = 0; j < y; j++)
                        {
                            if (i < 50)
                            {
                             
                                Rectangle rect = new Rectangle(10 + i * 5, j*5, 5, 5);
                                
                                rectangle.DrawRectangle(pen, rect);
                                int k = Convert.ToInt32(51 * xc[i][50]); // xc[i][j]


                                kolor = Color.FromArgb(k * 5, k * 2, k);
                                SolidBrush brush = new SolidBrush(kolor);
                                rectangle.FillRectangle(brush, rect);
                            }
                            double tmp = 0;
                            tmp = (1 - vy * dt * grad[1][i][j] + D[1][1] * dt * rozyy[i][j] * rozyy[i][j]) * xc[i][j] + 0.5 * (-vx * dt * grad[0][i][j] + D[0][0] * dt * rozxx[i][j] + rozxx[i][j] + 2 * D[0][1] * dt * rozxy[i][j]) * xc[i][j]; //niejawny w kierunku x, jawny w kierunku y
                            xc[i][j] = (tmp + (-0.5 * (vy * dt * grad[1][i][j] + D[1][1] * dt * rozyy[i][j] * rozyy[i][j]) + xc[i][j])) / (2 * (i + 1)); //jawny w kierunku x, niejawny  w y

                            /*Console.WriteLine()
                            Console.WriteLine()
                            Console.WriteLine()
                            Console.WriteLine()
                            Console.WriteLine()
                            Console.WriteLine()
 
                            /*Console.WriteLine("vy = " + vy);
                            Console.WriteLine("dt = " + dt);
                            Console.WriteLine("grad[1][i][j] = " + grad[1][i][j]);
                            Console.WriteLine("D[1][1] = " + D[1][1]);
                            Console.WriteLine("rozyy[i][j] = " + rozyy[i][j]);*/
                            if (i < 4)
                            {
                                Console.WriteLine("steps=" + t + "\ti=" + i + "\tj=" + j + "\txc[i][j] = " + xc[i][j]);

                            }
                       
                        }





                }
            }

            MessageBox.Show("Wykonano wszystkie operacje!", "Koniec Obliczeń");
        }

        public Form1()
        {
            InitializeComponent();
        }

        private void Form1_Load(object sender, EventArgs e)
        {


        }

        private void button2_ClientSizeChanged(object sender, EventArgs e)
        { }

        private void button2_Click(object sender, EventArgs e)
        {
            this.Close();
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {

        }

        private void label2_Click(object sender, EventArgs e)
        {

        }
    }
}