using System;
using System.Collections.Generic;
using System.Linq;
using Microsoft.Xna.Framework;
using Microsoft.Xna.Framework.Audio;
using Microsoft.Xna.Framework.Content;
using Microsoft.Xna.Framework.GamerServices;
using Microsoft.Xna.Framework.Graphics;
using Microsoft.Xna.Framework.Input;
using Microsoft.Xna.Framework.Media;

using FarseerPhysics.Collision;
using FarseerPhysics.Dynamics;
using FarseerPhysics.Factories;
using FarseerPhysics.Collision.Shapes;

namespace Przyklad
{
    /// <summary>
    /// This is the main type for your game
    /// </summary>
    public class Game1 : Microsoft.Xna.Framework.Game
    {
        GraphicsDeviceManager graphics;
        SpriteBatch spriteBatch;

        World swiat; //pole zawierajce wiat
        Body podloze; //pole zawierajce ciao podoa
        Body box1;
        Body box2;

        public Texture2D TPodloze;
        public Texture2D TBox;

        private const float MeterInPixels = 16f;


        public Game1()
        {
            graphics = new GraphicsDeviceManager(this);
            Content.RootDirectory = "Content";

            graphics.PreferredBackBufferWidth = 1280;
            graphics.PreferredBackBufferHeight = 720;
            //graphics.IsFullScreen = false;
            //graphics.ToggleFullScreen();

        }

        /// <summary>
        /// Allows the game to perform any initialization it needs to before starting to run.
        /// This is where it can query for any required services and load any non-graphic
        /// related content.  Calling base.Initialize will enumerate through any components
        /// and initialize them as well.
        /// </summary>
        protected override void Initialize()
        {
            TPodloze = Content.Load<Texture2D>(@"Sprites\groundSprite");
            TBox = Content.Load<Texture2D>(@"Sprites\boxSprite");           // TODO: Add your initialization logic here

            swiat = new World(new Vector2(0f, 9.82f));
            podloze = BodyFactory.CreateRectangle(swiat, 1280 / MeterInPixels, 76f / MeterInPixels, 1f);

            podloze.Position = new Vector2(640 / MeterInPixels, 700 / MeterInPixels);
            podloze.BodyType = BodyType.Static;
            podloze.Restitution = 0.1f;
            podloze.Friction = 1.5f;

            box1 = BodyFactory.CreateRectangle
                (swiat, TBox.Width / MeterInPixels, TBox.Height / MeterInPixels, 1f);
            box2 = BodyFactory.CreateRectangle
                (swiat, TBox.Width / MeterInPixels, TBox.Height / MeterInPixels, 1f);

            box1.Position = new Vector2(400 / MeterInPixels, 400 / MeterInPixels);
            box1.BodyType = BodyType.Dynamic;
            box1.Restitution = 0.3f;
            box1.Friction = 2f;
            box1.Mass = 5f;
            box1.Rotation = 3f;
            box1.LinearVelocity = new Vector2(10f, 0);
            
            box2.Position = new Vector2(600 / MeterInPixels, 400 / MeterInPixels);
            box2.BodyType = BodyType.Dynamic;
            box2.Restitution = 0.3f;
            box2.Friction = 2f;
            box2.Mass = 3f;
            box2.Rotation = -5f;
            box2.LinearVelocity = new Vector2(-10f, 0);

            base.Initialize();
        }

        /// <summary>
        /// LoadContent will be called once per game and is the place to load
        /// all of your content.
        /// </summary>
        protected override void LoadContent()
        {
            // Create a new SpriteBatch, which can be used to draw textures.
            spriteBatch = new SpriteBatch(GraphicsDevice);

            // TODO: use this.Content to load your game content here
        }

        /// <summary>
        /// UnloadContent will be called once per game and is the place to unload
        /// all content.
        /// </summary>
        protected override void UnloadContent()
        {
            // TODO: Unload any non ContentManager content here
        }

        /// <summary>
        /// Allows the game to run logic such as updating the world,
        /// checking for collisions, gathering input, and playing audio.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Update(GameTime gameTime)
        {
            // Allows the game to exit
            if (GamePad.GetState(PlayerIndex.One).Buttons.Back == ButtonState.Pressed)
                this.Exit();

            // TODO: Add your update logic here
            swiat.Step((float)gameTime.ElapsedGameTime.TotalMilliseconds * 0.001f);

            base.Update(gameTime);
        }

        /// <summary>
        /// This is called when the game should draw itself.
        /// </summary>
        /// <param name="gameTime">Provides a snapshot of timing values.</param>
        protected override void Draw(GameTime gameTime)
        {
            GraphicsDevice.Clear(Color.AliceBlue);

            //jest to odrobin niewydajne, aby tworzy przy kadej klatce ten obiekt
            //jednak w tak maym projekcie nie ma to znaczenia
            Vector2 groundOrigin = new Vector2(TPodloze.Width / 2f, TPodloze.Height / 2f);
            Vector2 boxOrigin = new Vector2(TBox.Width / 2f, TBox.Height / 2f);

            spriteBatch.Begin();
            spriteBatch.Draw(TPodloze, podloze.Position * MeterInPixels, null, 
                Color.White, 0f, groundOrigin, 1f, SpriteEffects.None, 0f);
            spriteBatch.End();

            spriteBatch.Begin();
            spriteBatch.Draw
                (TBox, box1.Position * MeterInPixels, null, Color.White, 
                box1.Rotation, boxOrigin, 1f, SpriteEffects.None, 0f);
            spriteBatch.Draw
                (TBox, box2.Position * MeterInPixels, null, Color.White,
                box2.Rotation, boxOrigin, 1f, SpriteEffects.None, 0f);
            spriteBatch.End();
            // TODO: Add your drawing code here

            base.Draw(gameTime);
        }
    }
}
