﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Windows.Forms;

using System.Xml;

namespace Xml
{
    public partial class Form1 : Form
    {
        public Form1()
        {
            InitializeComponent();
        }

        private string plikUstawien = "Ustawienia.xml";

        private void Form1_FormClosed(object sender, FormClosedEventArgs e)
        {
            XmlTextWriter xml = null;
            try
            {
                //tworzenie pliku
                xml = new XmlTextWriter(plikUstawien, System.Text.Encoding.UTF8);
                xml.Formatting = Formatting.Indented;
                xml.WriteStartDocument(true); //wersja XML itp.

                xml.WriteComment("Parametry aplikacji"); //komentarz

                //<opcje>>
                xml.WriteStartElement("opcje");

                //<okno nazwa=Form1>
                xml.WriteStartElement("okno");
                xml.WriteAttributeString("nazwa", this.Text);
                //<pozycja>
                xml.WriteStartElement("pozycja");
                xml.WriteElementString("X", this.Left.ToString());
                xml.WriteElementString("Y", this.Top.ToString());
                xml.WriteEndElement();
                //</pozycja>
                //<wielkość>
                xml.WriteStartElement("wielkość");
                xml.WriteElementString("Szer", this.Width.ToString());
                xml.WriteElementString("Wys", this.Height.ToString());
                xml.WriteEndElement();
                //</wielkość>
                xml.WriteEndElement();
                //</okno>

                xml.WriteEndElement();
                //</opcje>

                xml.WriteEndDocument(); //koniec dokumentu
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd w zapisywaniu ustawień do pliku (" + exc.Message + ")");
            }
            finally
            {
                xml.Close();
            }
        }

        private void Form1_Load(object sender, EventArgs e)
        {
            XmlTextReader xml = null;
            try
            {
                xml = new XmlTextReader(plikUstawien);

                //<opcje>>
                xml.ReadStartElement("opcje");

                //<okno nazwa=Form1>
                xml.Read();
                this.Text = xml["nazwa"];
                xml.ReadStartElement("okno");
                //<pozycja>
                xml.ReadStartElement("pozycja");
                this.Left = int.Parse(xml.ReadElementString("X"));
                this.Top = int.Parse(xml.ReadElementString("Y"));
                xml.ReadEndElement();
                //</pozycja>
                //<wielkość>
                xml.ReadStartElement("wielkość");
                this.Width = int.Parse(xml.ReadElementString("Szer"));
                this.Height = int.Parse(xml.ReadElementString("Wys"));
                xml.ReadEndElement();
                //</wielkość>
                xml.ReadEndElement();
                //</okno>

                xml.ReadEndElement();
                //</opcje>
            }
            catch (Exception exc)
            {
                MessageBox.Show("Błąd w odczytywaniu ustawień z pliku (" + exc.Message + ")");
            }
            finally
            {
                xml.Close();
            }

            textBox1.Text = this.Text;
        }

        private string analizaPlikuXML(string plikXML)
        {
            if (!System.IO.File.Exists(plikXML))
                throw new Exception("Pliku " + plikXML + " nie istnieje");

            XmlReader xml = null;
            XmlReaderSettings ustawienia = new XmlReaderSettings();
            ustawienia.IgnoreWhitespace = true;
            ustawienia.IgnoreProcessingInstructions = true;

            string s = "";

            try
            {
                xml = XmlReader.Create(plikXML, ustawienia);

                while (xml.Read())
                {
                    s += "(" + xml.Depth + ")\t";
                    switch (xml.NodeType)
                    {
                        case XmlNodeType.XmlDeclaration: s += "Deklaracja: " + xml.Value; break;
                        case XmlNodeType.Comment: s += "Komentarz: " + xml.Value; break;
                        //case XmlNodeType.Element: s += "Element: " + xml.Name; break;
                        case XmlNodeType.Element:
                            s += "Element: " + xml.Name;
                            if (xml.HasAttributes)
                            {
                                s += ", atrybuty: ";
                                for (int i = 0; i < xml.AttributeCount; i++)
                                {
                                    xml.MoveToAttribute(i);
                                    s += xml.Name + "=" + xml.QuoteChar + xml.Value + xml.QuoteChar + " ";
                                }
                            }
                            break;
                        case XmlNodeType.EndElement: s += "Zakończenie elementu: " + xml.Name; break;
                        case XmlNodeType.Text: s += "Tekst: " + xml.Value; break;
                    }
                    s += "\n";
                }
            }
            catch (Exception exc)
            {
                throw new Exception("Błąd podczas czytania danych z pliku (" + exc.Message + ")");
            }
            finally
            {
                xml.Close();
            }

            return s;
        }

        private void button1_Click(object sender, EventArgs e)
        {
            try
            {
                MessageBox.Show(analizaPlikuXML(plikUstawien));
            }
            catch (Exception exc)
            {
                MessageBox.Show(exc.Message, "Błąd w trakie analizy pliku XML");
            }
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {
            this.Text = textBox1.Text;
        }
    }
}
